<?php
session_start();
$conn = new mysqli('localhost', 'root', '', 'car_management');
if($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$message = "";
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $conn->real_escape_string($_POST['name']);
    $email = $conn->real_escape_string($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);

    // Get selected systems (array)
    $systems = $_POST['system_access'] ?? [];
    if(!is_array($systems)) $systems = [$systems];
    $systems_json = $conn->real_escape_string(json_encode($systems));

    $check = $conn->query("SELECT * FROM users WHERE email='$email'");
    if($check->num_rows > 0){
        $message = "Email already registered.";
    } else {
        $conn->query("INSERT INTO users (name,email,password,system_access) VALUES ('$name','$email','$password','$systems_json')");
        $message = "Registration successful! You can now <a href='single_login.php'>Login</a>.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Register - Fleet / Printer Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container d-flex justify-content-center align-items-center vh-100">
    <div class="card shadow p-4" style="max-width:400px;width:100%;">
        <h3 class="text-center mb-3">Register</h3>
        <?php if($message): ?><div class="alert alert-info"><?= $message ?></div><?php endif; ?>
        <form method="POST">
            <div class="mb-3">
                <label>Name</label>
                <input type="text" name="name" class="form-control" required>
            </div>

            <div class="mb-3">
                <label>Email</label>
                <input type="email" name="email" class="form-control" required>
            </div>

            <div class="mb-3">
                <label>Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>

            <div class="mb-3">
                <label>System Access</label>
                <select name="system_access[]" class="form-select" multiple required>
                    <option value="fleet">Fleet Management</option>
                    <option value="printers">Printer Management</option>
                </select>
                <small class="text-muted">Hold Ctrl (Windows) or Cmd (Mac) to select multiple.</small>
            </div>

            <button type="submit" class="btn btn-success w-100">Register</button>
        </form>

        <p class="text-center mt-3">Already have an account? <a href="login.php">Login</a></p>
    </div>
</div>
</body>
</html>
