<?php
session_start();
$conn = new mysqli('localhost', 'root', '', 'car_management');
if($conn->connect_error) die("Connection failed: " . $conn->connect_error);

/* ================= REGISTER ================= */
$reg_msg = "";
if(isset($_POST['action']) && $_POST['action'] === 'register'){
    $name = $conn->real_escape_string($_POST['name']);
    $email = $conn->real_escape_string($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $system_access = $conn->real_escape_string($_POST['system_access']);

    $check = $conn->query("SELECT id FROM users WHERE email='$email'");
    if($check->num_rows > 0){
        $reg_msg = "Email already registered.";
    } else {
        $conn->query("INSERT INTO users (name,email,password,system_access)
                      VALUES ('$name','$email','$password','$system_access')");
        $reg_msg = "Registration successful! You can now login.";
    }
}

/* ================= LOGIN ================= */
$login_msg = "";
if(isset($_POST['action']) && $_POST['action'] === 'login'){
    $email = $conn->real_escape_string($_POST['email']);
    $password = $_POST['password'] ?? '';

    $res = $conn->query("SELECT * FROM users WHERE email='$email' LIMIT 1");
    if($res->num_rows > 0){
        $user = $res->fetch_assoc();
        if(password_verify($password, $user['password'])){
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['system_access'] = $user['system_access'];

            header("Location: " . ($user['system_access'] === 'fleet'
                            ? "index.php"
                            : "printersdashboard.php"));
            exit;
        } else {
            $login_msg = "Incorrect password.";
        }
    } else {
        $login_msg = "User not found.";
    }
}

/* ================= FORGOT PASSWORD DIRECT RESET ================= */
$forgot_msg = "";
if(isset($_POST['action']) && $_POST['action'] === 'forgot'){
    $email = $conn->real_escape_string($_POST['email']);
    $password = $_POST['new_password'] ?? '';
    $confirm = $_POST['confirm_password'] ?? '';

    if($password !== $confirm){
        $forgot_msg = "Passwords do not match!";
    } else {
        $res = $conn->query("SELECT id FROM users WHERE email='$email'");
        if($res->num_rows > 0){
            $hash = password_hash($password, PASSWORD_BCRYPT);
            $conn->query("UPDATE users SET password='$hash' WHERE email='$email'");
            $forgot_msg = "Password updated successfully! You can now login.";
        } else {
            $forgot_msg = "Email not found.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login & Registration - Fleet / Printers</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{background:#f8f9fa;}
        .card{max-width:600px;width:100%;padding:30px;border-radius:10px;}
    </style>
</head>
<body>

<div class="container d-flex justify-content-center align-items-center vh-100">
    <div class="card shadow">

        <ul class="nav nav-tabs mb-3">
            <li class="nav-item"><a href="#" class="nav-link active" id="loginTab">Login</a></li>
            <li class="nav-item"><a href="#" class="nav-link" id="registerTab">Register</a></li>
        </ul>

        <!-- ================= LOGIN ================= -->
        <div id="loginForm">
            <?php if($login_msg): ?><div class="alert alert-danger"><?= $login_msg ?></div><?php endif; ?>

            <form method="POST">
                <input type="hidden" name="action" value="login">
                <div class="mb-3">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label>Password</label>
                    <input type="password" name="password" class="form-control" required>
                </div>
                <button class="btn btn-primary w-100">Login</button>
            </form>

            <!-- Forgot Password link triggers modal -->
            <div class="text-center mt-3">
                <a href="#" data-bs-toggle="modal" data-bs-target="#forgotModal">Forgot password?</a>
            </div>
        </div>

        <!-- ================= REGISTER ================= -->
        <div id="registerForm" style="display:none;">
            <?php if($reg_msg): ?><div class="alert alert-info"><?= $reg_msg ?></div><?php endif; ?>
            <form method="POST">
                <input type="hidden" name="action" value="register">
                <div class="mb-3"><label>Name</label>
                    <input type="text" name="name" class="form-control" required></div>
                <div class="mb-3"><label>Email</label>
                    <input type="email" name="email" class="form-control" required></div>
                <div class="mb-3"><label>Password</label>
                    <input type="password" name="password" class="form-control" required></div>
                <div class="mb-3">
                    <label>System Access</label>
                    <select name="system_access" class="form-select" required>
                        <option value="">Select system</option>
                        <option value="fleet">Fleet Management</option>
                        <option value="printers">Printer Dashboard</option>
                    </select>
                </div>
                <button class="btn btn-success w-100">Register</button>
            </form>
        </div>

    </div>
</div>

<!-- ================= FORGOT PASSWORD MODAL ================= -->
<div class="modal fade" id="forgotModal" tabindex="-1" aria-labelledby="forgotModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST">
                <input type="hidden" name="action" value="forgot">
                <div class="modal-header">
                    <h5 class="modal-title" id="forgotModalLabel">Reset Password</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Email address</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>New Password</label>
                        <input type="password" name="new_password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Confirm Password</label>
                        <input type="password" name="confirm_password" class="form-control" required>
                    </div>
                    <?php if($forgot_msg): ?>
                        <div class="alert alert-info"><?= $forgot_msg ?></div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-100">Reset Password</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    loginTab.onclick = () => {
        loginTab.classList.add('active');
        registerTab.classList.remove('active');
        loginForm.style.display='block';
        registerForm.style.display='none';
    }
    registerTab.onclick = () => {
        registerTab.classList.add('active');
        loginTab.classList.remove('active');
        loginForm.style.display='none';
        registerForm.style.display='block';
    }
</script>
</body>
</html>
