<?php
$conn = new mysqli('localhost', 'root', '', 'car_management');
if($conn->connect_error) die("Connection failed: " . $conn->connect_error);

session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

if($_SERVER['REQUEST_METHOD'] === 'POST'){

    // Vehicles
    if(isset($_POST['action_vehicle'])){
        $id = $_POST['vehicle_id'] ?? null;
        $reg = $_POST['vehicle_name'];
        $brand = $_POST['brand'];
        $model = $_POST['model'];
        $year = $_POST['year'];
        $expiry = $_POST['registration_expiry'] ?? null;
        $status = $_POST['status'];

        if($_POST['action_vehicle'] === 'add'){
            $conn->query("INSERT INTO vehicles (plate_number, brand, model, year, registration_expiry, status)
                          VALUES ('$reg','$brand','$model','$year','$expiry','$status')");
        } else {
            $conn->query("UPDATE vehicles SET plate_number='$reg', brand='$brand', model='$model', year='$year', registration_expiry='$expiry', status='$status'
                          WHERE id='$id'");
        }
    }

    // Maintenance
    if(isset($_POST['action_maintenance'])){
        $id = $_POST['maintenance_id'] ?? null;
        $vehicle_id = $_POST['vehicle_id'];
        $service = $_POST['service_type'];
        $date = $_POST['service_date'];
        $cost = $_POST['cost'] ?? 0;
        $mechanic = $_POST['mechanic'];
        $next = $_POST['next_service_date'];
        $status = $_POST['status'];

        if($_POST['action_maintenance'] === 'add'){
            $conn->query("INSERT INTO maintenance_logs (vehicle_id, service_type, service_date, cost, mechanic_name, next_service_date, status)
                          VALUES ('$vehicle_id','$service','$date','$cost','$mechanic','$next','$status')");
        } else {
            $conn->query("UPDATE maintenance_logs SET vehicle_id='$vehicle_id', service_type='$service', service_date='$date',
                          cost='$cost', mechanic_name='$mechanic', next_service_date='$next', status='$status' WHERE id='$id'");
        }
    }

    // Fuel
    if(isset($_POST['action_fuel'])){
        $id = $_POST['fuel_id'] ?? null;
        $vehicle_id = $_POST['vehicle_id'];
        $date = $_POST['date'];
        $liters = $_POST['liters'];
        $cost = $_POST['cost'];
        $invoice = $_POST['invoice_no'];
        $mileage = $_POST['mileage'];

        if($_POST['action_fuel'] === 'add'){
            $conn->query("INSERT INTO fuel_logs (vehicle_id, date, liters, cost, invoice_no, mileage)
                          VALUES ('$vehicle_id','$date','$liters','$cost','$invoice','$mileage')");
        } else {
            $conn->query("UPDATE fuel_logs SET vehicle_id='$vehicle_id', date='$date', liters='$liters', mileage='$mileage', cost='$cost', invoice_no='$invoice'
                          WHERE id='$id'");
        }
    }

    // ✅ Redirect after processing to prevent duplicate submission
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// DELETE Handling (GET requests)
if(isset($_GET['delete_vehicle'])) $conn->query("DELETE FROM vehicles WHERE id=".$_GET['delete_vehicle']);
if(isset($_GET['delete_maintenance'])) $conn->query("DELETE FROM maintenance_logs WHERE id=".$_GET['delete_maintenance']);
if(isset($_GET['delete_fuel'])) $conn->query("DELETE FROM fuel_logs WHERE id=".$_GET['delete_fuel']);

// Fetch Data
$vehicles = $conn->query("SELECT * FROM vehicles");
$maintenance_logs = $conn->query("SELECT m.*, v.plate_number as registration_number FROM maintenance_logs m JOIN vehicles v ON m.vehicle_id=v.id");
$fuel_logs = $conn->query("SELECT f.*, v.plate_number as registration_number FROM fuel_logs f JOIN vehicles v ON f.vehicle_id=v.id");

// Stats
$totalVehicles = $vehicles->num_rows;
$totalMaintenance = $maintenance_logs->num_rows;
$pendingMaintenance = $conn->query("SELECT * FROM maintenance_logs WHERE status='Pending'")->num_rows;
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Fleet Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<!-- Toast Container -->
<div id="toastContainer" class="position-fixed top-0 end-0 p-3" style="z-index: 1100;"></div>


<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4 border rounded">
    <div class="container-fluid">
        <a class="navbar-brand fw-bold text-primary" href="index.php">Fleet Management Dashboard</a>
        <div class="d-flex ms-auto align-items-center">
      <span class="navbar-text text-dark me-3">
        Welcome, <strong><?= htmlspecialchars($_SESSION['user_name']); ?></strong>
      </span>
            <a href="logout.php" class="btn btn-outline-primary btn-sm">Logout</a>
        </div>
    </div>

</nav>

    <!-- Stats Cards -->
    <div class="row g-3 mb-3">
        <div class="col-md-4"><div class="card text-center p-2"><h5>Vehicles</h5><p class="fs-3"><?= $totalVehicles ?></p></div></div>
        <div class="col-md-4"><div class="card text-center p-2"><h5>Total Maintenance</h5><p class="fs-3"><?= $totalMaintenance ?></p></div></div>
        <div class="col-md-4"><div class="card text-center p-2"><h5>Pending Maintenance</h5><p class="fs-3"><?= $pendingMaintenance ?></p></div></div>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-tabs" id="fleetTabs">
        <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#vehicles_tab">Vehicles</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#maintenance_tab">Maintenance</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#fuel_tab">Fuel & Expenses</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#reports_tab">Reports</button></li>
    </ul>

    <div class="tab-content mt-3">
        <!-- Vehicles -->
        <div class="tab-pane fade show active" id="vehicles_tab">
            <h4>Vehicles</h4>
            <button class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#vehicleModal" onclick="resetVehicleForm()">Add Vehicle</button>
            <table class="table table-striped">
                <th>ID</th>
                <th>Reg</th>
                <th>Brand</th>
                <th>Model</th>
                <th>Expiry</th>
                <th>Status</th>
                <th>Actions</th>
                <tbody>
                <?php
                $vehicles->data_seek(0);
                while($v = $vehicles->fetch_assoc()): ?>
                    <tr>
                        <td><?= $v['id'] ?></td>
                        <td><?= htmlspecialchars($v['plate_number']) ?></td>
                        <td><?= htmlspecialchars($v['brand']) ?></td>
                        <td><?= htmlspecialchars($v['model']) ?></td>
                        <td><?= htmlspecialchars($v['registration_expiry']) ?></td>
                        <td><?= htmlspecialchars($v['status']) ?></td>
                        <td>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#vehicleModal"
                                    onclick="editVehicle(<?= $v['id'] ?>,'<?= htmlspecialchars($v['plate_number'],ENT_QUOTES) ?>','<?= htmlspecialchars($v['brand'],ENT_QUOTES) ?>','<?= htmlspecialchars($v['model'],ENT_QUOTES) ?>','<?= $v['registration_expiry'] ?>','<?= $v['status'] ?>')">Edit</button>
                            <a href="?delete_vehicle=<?= $v['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete vehicle?')">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- Maintenance -->
        <div class="tab-pane fade" id="maintenance_tab">
            <h4>Maintenance Logs</h4>
            <button class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#maintenanceModal" onclick="resetMaintenanceForm()">Add Maintenance</button>
            <table class="table table-striped">
                <thead><tr><th>Vehicle</th><th>Service</th><th>Date</th><th>Cost</th><th>Mechanic</th><th>Next</th><th>Status</th><th>Actions</th></tr></thead>
                <tbody>
                <?php while($m = $maintenance_logs->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($m['registration_number']) ?></td>
                        <td><?= htmlspecialchars($m['service_type']) ?></td>
                        <td><?= htmlspecialchars($m['service_date']) ?></td>
                        <td><?= htmlspecialchars($m['cost']) ?></td>
                        <td><?= htmlspecialchars($m['mechanic_name']) ?></td>
                        <td><?= htmlspecialchars($m['next_service_date']) ?></td>
                        <td><?= htmlspecialchars($m['status']) ?></td>
                        <td>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#maintenanceModal"
                                    onclick="editMaintenance(<?= $m['id'] ?>,<?= $m['vehicle_id'] ?>,'<?= htmlspecialchars($m['service_type'],ENT_QUOTES) ?>','<?= $m['service_date'] ?>','<?= $m['cost'] ?>','<?= htmlspecialchars($m['mechanic_name'],ENT_QUOTES) ?>','<?= $m['next_service_date'] ?>','<?= $m['status'] ?>')">Edit</button>
                            <a href="?delete_maintenance=<?= $m['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete maintenance?')">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- Fuel -->
        <div class="tab-pane fade" id="fuel_tab">
            <h4>Fuel & Expenses</h4>
            <button class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#fuelModal" onclick="resetFuelForm()">Add Fuel</button>
            <table class="table table-striped">
                <thead><tr><th>Vehicle</th><th>Date</th><th>Liters</th><th>Cost</th><th>Invoice</th><th>Mileage</th><th>Actions</th></tr></thead>
                <tbody>
                <?php while($f = $fuel_logs->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($f['registration_number']) ?></td>
                        <td><?= htmlspecialchars($f['date']) ?></td>
                        <td><?= htmlspecialchars($f['liters']) ?></td>
                        <td><?= htmlspecialchars($f['cost']) ?></td>
                        <td><?= htmlspecialchars($f['invoice_no']) ?></td>
                        <td><?= htmlspecialchars($f['mileage']) ?></td>
                        <td>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#fuelModal"
                                    onclick="editFuel(<?= $f['id'] ?>,<?= $f['vehicle_id'] ?>,'<?= $f['date'] ?>','<?= $f['liters'] ?>','<?= $f['cost'] ?>','<?= htmlspecialchars($f['invoice_no'],ENT_QUOTES) ?>','<?= $f['mileage'] ?>')">Edit</button>
                            <a href="?delete_fuel=<?= $f['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete fuel log?')">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!--  Modals  -->

<!-- Vehicle Modal -->
<div class="modal fade" id="vehicleModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Vehicle</h5></div>
            <div class="modal-body">
                <input type="hidden" name="vehicle_id" id="vehicle_id">
                <input type="hidden" name="action_vehicle" id="action_vehicle" value="add">

                <div class="mb-2"><label>Registration</label>
                    <input type="text" name="vehicle_name" id="vehicle_name" class="form-control" required></div>
                <div class="mb-2"><label>Brand</label>
                    <input type="text" name="brand" id="brand" class="form-control" required></div>
                <div class="mb-2"><label>Model</label>
                    <input type="text" name="model" id="model" class="form-control" required></div>

                <div class="mb-2"><label>Registration Expiry</label>
                    <input type="date" name="registration_expiry" id="registration_expiry" class="form-control"></div>
                <div class="mb-2"><label>Status</label>
                    <select name="status" id="status" class="form-select">
                        <option>Active</option>
                        <option>Maintenance</option>
                        <option>Inactive</option>
                    </select></div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">Save</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </form>
    </div>
</div>

<!-- Maintenance Modal -->
<div class="modal fade" id="maintenanceModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Maintenance</h5></div>
            <div class="modal-body">
                <input type="hidden" name="maintenance_id" id="maintenance_id">
                <input type="hidden" name="action_maintenance" id="action_maintenance" value="add">

                <div class="mb-2"><label>Vehicle</label>
                    <select name="vehicle_id" id="maintenance_vehicle_id" class="form-select" required>
                        <option value="">Select Vehicle</option>
                        <?php
                        $vehicles->data_seek(0);
                        while($v = $vehicles->fetch_assoc()) echo "<option value='{$v['id']}'>{$v['plate_number']}</option>";
                        ?>
                    </select></div>
                <div class="mb-2"><label>Service Type</label>
                    <input type="text" name="service_type" id="service_type" class="form-control" required></div>
                <div class="mb-2"><label>Service Date</label>
                    <input type="date" name="service_date" id="service_date" class="form-control" required></div>
                <div class="mb-2"><label>Cost</label>
                    <input type="number" name="cost" id="cost" class="form-control"></div>
                <div class="mb-2"><label>Mechanic</label>
                    <input type="text" name="mechanic" id="mechanic" class="form-control"></div>
                <div class="mb-2"><label>Next Service Date</label>
                    <input type="date" name="next_service_date" id="next_service_date" class="form-control"></div>
                <div class="mb-2"><label>Status</label>
                    <select name="status" id="maintenance_status" class="form-select">
                        <option>Completed</option>
                        <option>Pending</option>
                    </select></div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">Save</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </form>
    </div>
</div>

<!-- Fuel Modal -->
<div class="modal fade" id="fuelModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Fuel Log</h5></div>
            <div class="modal-body">
                <input type="hidden" name="fuel_id" id="fuel_id">
                <input type="hidden" name="action_fuel" id="action_fuel" value="add">

                <div class="mb-2"><label>Vehicle</label>
                    <select name="vehicle_id" id="fuel_vehicle_id" class="form-select" required>
                        <option value="">Select Vehicle</option>
                        <?php
                        $vehicles->data_seek(0);
                        while($v = $vehicles->fetch_assoc()) echo "<option value='{$v['id']}'>{$v['plate_number']}</option>";
                        ?>
                    </select></div>
                <div class="mb-2"><label>Date</label>
                    <input type="date" name="date" id="date" class="form-control" required></div>
                <div class="mb-2"><label>Liters</label>
                    <input type="number" name="liters" id="liters" class="form-control" required></div>
                <div class="mb-2"><label>Cost</label>
                    <input type="number" name="cost" id="fuel_cost" class="form-control" required></div>
                <div class="mb-2"><label>Invoice No</label>
                    <input type="text" name="invoice_no" id="invoice_no" class="form-control"></div>
                <div class="mb-2"><label>Mileage</label>
                    <input type="number" name="mileage" id="mileage" class="form-control"></div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">Save</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </form>
    </div>
</div>
<div class="tab-pane fade" id="reports_tab">
    <h4>Reports & Analytics</h4>


    <!-- Report Period Selector -->
    <div class="d-flex align-items-center mb-3">
        <select id="report_period" class="form-select w-auto me-2" onchange="toggleMonthYearSelector()">
            <option value="week">This Week</option>
            <option value="month">Select Month</option>
            <option value="year" selected>This Year</option>
        </select>

        <select id="report_month" class="form-select w-auto me-2" style="display:none;" onchange="updateCharts()">
            <?php
            $months = [
                    1=>'January',2=>'February',3=>'March',4=>'April',5=>'May',6=>'June',
                    7=>'July',8=>'August',9=>'September',10=>'October',11=>'November',12=>'December'
            ];
            foreach($months as $num=>$name){
                $selected = ($num == date('n')) ? 'selected' : '';
                echo "<option value='$num' $selected>$name</option>";
            }
            ?>
        </select>

        <select id="report_year" class="form-select w-auto" style="display:none;" onchange="updateCharts()">
            <?php
            $currentYear = date('Y');
            for($y=$currentYear-5; $y<=$currentYear; $y++){
                $selected = ($y==$currentYear)?'selected':'';
                echo "<option value='$y' $selected>$y</option>";
            }
            ?>
        </select>
    </div>


    <div class="row">
        <div class="col-md-6">
            <h6>Maintenance Cost per Vehicle</h6>
            <canvas id="maintenanceCostChart" height="180"></canvas>
        </div>
        <div class="col-md-6">
            <h6>Fuel Cost per Vehicle</h6>
            <canvas id="fuelUsageChart" height="180"></canvas>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // ===== VEHICLES =====
    function resetVehicleForm() {
        document.getElementById('action_vehicle').value = 'add';
        document.querySelector('#vehicleModal form').reset();
    }

    function editVehicle(id, reg, brand, model, year, expiry, status) {
        document.getElementById('vehicle_id').value = id;
        document.getElementById('action_vehicle').value = 'edit';
        document.getElementById('vehicle_name').value = reg;
        document.getElementById('brand').value = brand;
        document.getElementById('model').value = model;
        document.getElementById('registration_expiry').value = expiry;
        document.getElementById('status').value = status;
    }

    // ===== MAINTENANCE =====
    function resetMaintenanceForm() {
        document.getElementById('action_maintenance').value = 'add';
        document.querySelector('#maintenanceModal form').reset();
    }

    function editMaintenance(id, vehicle_id, service, date, cost, mechanic, next, status) {
        document.getElementById('maintenance_id').value = id;
        document.getElementById('action_maintenance').value = 'edit';
        document.getElementById('maintenance_vehicle_id').value = vehicle_id;
        document.getElementById('service_type').value = service;
        document.getElementById('service_date').value = date;
        document.getElementById('cost').value = cost;
        document.getElementById('mechanic').value = mechanic;
        document.getElementById('next_service_date').value = next;
        document.getElementById('maintenance_status').value = status;
    }

    // ===== FUEL =====
    function resetFuelForm() {
        document.getElementById('action_fuel').value = 'add';
        document.querySelector('#fuelModal form').reset();
    }

    function editFuel(id, vehicle_id, date, liters, cost, invoice, mileage) {
        document.getElementById('fuel_id').value = id;
        document.getElementById('action_fuel').value = 'edit';
        document.getElementById('fuel_vehicle_id').value = vehicle_id;
        document.getElementById('date').value = date;
        document.getElementById('liters').value = liters;
        document.getElementById('fuel_cost').value = cost;
        document.getElementById('invoice_no').value = invoice;
        document.getElementById('mileage').value = mileage;
    }

    // ===== CHARTS =====
    function toggleMonthYearSelector() {
        const period = document.getElementById('report_period').value;
        const show = (period === 'month');
        document.getElementById('report_month').style.display = show ? 'inline-block' : 'none';
        document.getElementById('report_year').style.display = show ? 'inline-block' : 'none';
        updateCharts();
    }

    async function updateCharts() {
        const period = document.getElementById('report_period').value;
        let url = 'chart_data.php?period=' + period;

        if(period === 'month'){
            const month = document.getElementById('report_month').value;
            const year = document.getElementById('report_year').value;
            url += `&month=${month}&year=${year}`;
        }

        try {
            const res = await fetch(url);
            const data = await res.json();

            // --- Maintenance Chart ---
            const ctx1 = document.getElementById('maintenanceCostChart').getContext('2d');
            if(window.maintenanceChart) window.maintenanceChart.destroy();
            window.maintenanceChart = new Chart(ctx1, {
                type: 'bar',
                data: { labels: data.maintenance.labels, datasets: [{ label:'Maintenance Cost', data:data.maintenance.values, backgroundColor:'rgba(54,162,235,0.6)', borderColor:'rgba(54,162,235,1)', borderWidth:1 }]},
                options: { responsive:true, plugins:{legend:{display:true}}, scales:{y:{beginAtZero:true}, x:{}} }
            });

            // --- Fuel Chart ---
            const ctx2 = document.getElementById('fuelUsageChart').getContext('2d');
            if(window.fuelChart) window.fuelChart.destroy();
            window.fuelChart = new Chart(ctx2, {
                type: 'bar',
                data: { labels: data.fuel.labels, datasets: [{ label:'Fuel Cost', data:data.fuel.values, backgroundColor:'rgba(250,99,132,0.7)', borderColor:'rgba(250,99,132,1)', borderWidth:1 }]},
                options: { responsive:true, plugins:{legend:{display:true}}, scales:{y:{beginAtZero:true}, x:{}} }
            });

        } catch(e) { console.error('Error loading charts:', e); }
    }

    // Initialize
    toggleMonthYearSelector();
    // Load charts on page load and when period changes
    updateCharts();
    document.getElementById('report_period').addEventListener('change', updateCharts);

    // ===== SYSTEM ALERTS =====
    async function loadSystemAlerts() {
        try {
            const res = await fetch('alerts.php');
            const data = await res.json();
            const container = document.getElementById('toastContainer');

            if (!data.length) return;

            data.forEach(alert => {
                let message = '';
                let bgClass = 'bg-info text-dark';

                if (alert.type === 'maintenance') {
                    message = `  <strong>${alert.vehicle}</strong> has maintenance due on <strong>${alert.date}</strong>`;
                    bgClass = 'bg-warning text-dark';
                } else if (alert.type === 'registration') {
                    message = ` <strong>${alert.vehicle}</strong>'s registration expires on <strong>${alert.date}</strong>`;
                    bgClass = 'bg-danger text-white';
                }

                // Create toast element
                const toast = document.createElement('div');
                toast.className = `toast align-items-center ${bgClass} border-0 mb-2`;
                toast.role = "alert";
                toast.ariaLive = "assertive";
                toast.ariaAtomic = "true";
                toast.innerHTML = `
                <div class="d-flex">
                    <div class="toast-body">${message}</div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                </div>
            `;
                container.appendChild(toast);

                // Show toast
                const bsToast = new bootstrap.Toast(toast, { delay: 8000 });
                bsToast.show();
            });

        } catch (e) {
            console.error('Error loading alerts:', e);
        }
    }

    // Load on page start & refresh every 10 seconds
    loadSystemAlerts();
    setInterval(loadSystemAlerts, 10000);

</script>

<!-- Footer -->
<footer class="bg-light text-center text-muted py-3 mt-auto border-top">
    &copy; 2025 BroadHorizonGroup
</footer>
</body>
</html>