<?php
// ================= Database =================
$conn = new mysqli('localhost', 'root', '', 'car_management');
if($conn->connect_error) die("Connection failed: " . $conn->connect_error);

// Helper: Get months in period (month or year)
function getMonthsInPeriod($period) {
    $months = [];
    $start = new DateTime();
    $end = new DateTime();

    switch($period) {
        case 'year':
            $start->modify('first day of january this year');
            $end->modify('last day of december this year');
            break;
        case 'month':
        default:
            $start->modify('first day of this month');
            $end = clone $start;
            break;
    }

    $interval = new DateInterval('P1M');
    $periodRange = new DatePeriod($start, $interval, $end->modify('+1 day'));

    foreach($periodRange as $dt) {
        $months[] = $dt; // store DateTime object for formatting later
    }

    return $months;
}

// ================= CSV Export =================
if(isset($_GET['period'])) {
    $period = $_GET['period'];
    if(!in_array($period,['month','year'])) $period = 'month'; // default

    $months = getMonthsInPeriod($period);

    $vehicles = $conn->query("SELECT * FROM vehicles");

    // CSV headers
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=report_'.$period.'.csv');
    $output = fopen('php://output', 'w');

    $header = ['Vehicle ID','Plate Number','Brand','Model'];
    foreach($months as $m) $header[] = $m->format('F Y').' Fuel';
    foreach($months as $m) $header[] = $m->format('F Y').' Maintenance';
    foreach($months as $m) $header[] = $m->format('F Y').' Total';
    fputcsv($output, $header);

    // Loop through vehicles
    while($v = $vehicles->fetch_assoc()) {
        $row = [$v['id'],$v['plate_number'],$v['brand'],$v['model']];
        $fuelCosts = [];
        $maintCosts = [];
        $totalCosts = [];

        foreach($months as $m) {
            $startDate = $m->format('Y-m-01');
            $endDate   = $m->format('Y-m-t');

            // Fuel
            $fuel_res = $conn->query("
                SELECT SUM(cost) as total_fuel 
                FROM fuel_logs 
                WHERE vehicle_id='{$v['id']}' 
                AND date BETWEEN '$startDate' AND '$endDate'
            ");
            $fuel_total = $fuel_res->fetch_assoc()['total_fuel'] ?? 0;

            // Maintenance
            $maint_res = $conn->query("
                SELECT SUM(cost) as total_maint 
                FROM maintenance_logs 
                WHERE vehicle_id='{$v['id']}' 
                AND service_date BETWEEN '$startDate' AND '$endDate'
            ");
            $maint_total = $maint_res->fetch_assoc()['total_maint'] ?? 0;

            $fuelCosts[] = number_format($fuel_total,2);
            $maintCosts[] = number_format($maint_total,2);
            $totalCosts[] = number_format($fuel_total + $maint_total,2);
        }

        $row = array_merge($row, $fuelCosts, $maintCosts, $totalCosts);
        fputcsv($output, $row);
    }

    fclose($output);
    exit;
}
?>
