<?php
$conn = new mysqli('localhost', 'root', '', 'car_management');
if($conn->connect_error) die("Connection failed: ".$conn->connect_error);

$period = $_GET['period'] ?? 'week';
$month  = $_GET['month'] ?? date('n'); // current month
$year   = $_GET['year'] ?? date('Y');  // current year

function getCostsByPeriod($conn, $table, $date_col, $cost_col, $period, $month=null, $year=null) {
    switch($period) {
        case 'week':
            $start = date('Y-m-d', strtotime('monday this week'));
            $where = "$date_col >= '$start'";
            break;
        case 'month':
            $start = "$year-$month-01";
            $end   = date('Y-m-t', strtotime($start)); // last day of month
            $where = "$date_col BETWEEN '$start' AND '$end'";
            break;
        case 'year':
            $start = "$year-01-01";
            $where = "$date_col >= '$start'";
            break;
        default:
            $where = "1"; // no filter
    }

    $res = $conn->query("SELECT v.plate_number, SUM($table.$cost_col) as total
                         FROM $table
                         JOIN vehicles v ON $table.vehicle_id=v.id
                         WHERE $where
                         GROUP BY v.id");

    $labels = $totals = [];
    while($row = $res->fetch_assoc()){
        $labels[] = $row['plate_number'];
        $totals[] = (float)$row['total'];
    }

    return [$labels, $totals];
}

// Fetch maintenance & fuel costs
list($maint_labels, $maint_totals) = getCostsByPeriod($conn,'maintenance_logs','service_date','cost',$period,$month,$year);
list($fuel_labels, $fuel_totals) = getCostsByPeriod($conn,'fuel_logs','date','cost',$period,$month,$year);

// Return JSON
echo json_encode([
    'maintenance' => ['labels' => $maint_labels, 'values' => $maint_totals],
    'fuel' => ['labels' => $fuel_labels, 'values' => $fuel_totals]
]);
?>
