<?php
header('Content-Type: application/json');

$conn = new mysqli('localhost', 'root', '', 'car_management');
if ($conn->connect_error) {
    echo json_encode([]);
    exit;
}

$today = date('Y-m-d');
$alerts = [];

// Maintenance due within 7 days
$res1 = $conn->query("
    SELECT v.plate_number, m.next_service_date 
    FROM maintenance_logs m 
    JOIN vehicles v ON m.vehicle_id = v.id 
    WHERE m.next_service_date BETWEEN '$today' AND DATE_ADD('$today', INTERVAL 7 DAY)
");
while ($r = $res1->fetch_assoc()) {
    $alerts[] = [
        'type' => 'maintenance',
        'vehicle' => $r['plate_number'],
        'date' => $r['next_service_date']
    ];
}

// Registration expiring within 30 days
$res2 = $conn->query("
    SELECT plate_number, registration_expiry 
    FROM vehicles 
    WHERE registration_expiry BETWEEN '$today' AND DATE_ADD('$today', INTERVAL 30 DAY)
");
while ($r = $res2->fetch_assoc()) {
    $alerts[] = [
        'type' => 'registration',
        'vehicle' => $r['plate_number'],
        'date' => $r['registration_expiry']
    ];
}

echo json_encode($alerts);
?>
