<?php
header('Content-Type: application/json');
include 'db.php'; // make sure $conn or $mysqli is defined

try {
    $alerts = [];

    // --- MAINTENANCE ALERTS ---
    $stmt = $conn->prepare("
        SELECT m.id, v.plate_number AS vehicle, m.service_type, m.next_service_date, m.status
        FROM maintenance_logs m
        JOIN vehicles v ON m.vehicle_id = v.id
        WHERE m.status != 'Completed' OR m.next_service_date <= CURDATE()
        ORDER BY m.next_service_date ASC
    ");
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $alerts[] = [
            'type' => 'maintenance',
            'vehicle' => $row['vehicle'],
            'date' => $row['next_service_date'],
            'service' => $row['service_type']
        ];
    }

    // --- REGISTRATION ALERTS (next 30 days) ---
    $stmt = $conn->prepare("
        SELECT plate_number AS vehicle, registration_expiry
        FROM vehicles
        WHERE registration_expiry BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY)
    ");
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $alerts[] = [
            'type' => 'registration',
            'vehicle' => $row['vehicle'],
            'date' => $row['registration_expiry']
        ];
    }

    echo json_encode($alerts);

} catch (Exception $e) {
    echo json_encode([]);
}
