<?php
session_start();

// Logged-in worker info
$worker_id = $_SESSION['user_id'] ?? null;
$branch = $_SESSION['branch'] ?? null;

if (!$worker_id || !$branch) {
    die("You must be logged in to view this page.");
}

// DB connection
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) die("Database connection failed: " . $mysqli->connect_error);

// Fetch job cards where the worker is assigned to at least one stage
$stmt = $mysqli->prepare("
    SELECT DISTINCT jc.id AS job_card_id, jc.job_card_number, jc.department, jc.branch
    FROM job_card_stages jcs
    INNER JOIN job_cards jc ON jcs.job_card_id = jc.id
    WHERE jc.branch = ? AND FIND_IN_SET(?, jcs.assigned_to)
    ORDER BY jc.created_at ASC
");
$stmt->bind_param("si", $branch, $worker_id);
$stmt->execute();
$job_cards = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<h1>My Job Cards</h1>

<?php foreach ($job_cards as $job): ?>
    <h2>Job Card: <?= htmlspecialchars($job['job_card_number']) ?> (<?= htmlspecialchars($job['department']) ?>)</h2>

    <?php
    // Fetch all stages for this job card
    $stmt = $mysqli->prepare("SELECT * FROM job_card_stages WHERE job_card_id=? ORDER BY id ASC");
    $stmt->bind_param("i", $job['job_card_id']);
    $stmt->execute();
    $stages = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    ?>

    <table border="1" cellpadding="5">
        <tr>
            <th>Stage</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
        <?php foreach ($stages as $stage):
            $assigned_ids = array_map('trim', explode(',', $stage['assigned_to'] ?? ''));
            $is_my_stage = in_array($worker_id, $assigned_ids);
            $bgcolor = $is_my_stage ? '#d4edda' : ''; // highlight logged-in worker's stage
            ?>
            <tr style="background-color: <?= $bgcolor ?>">
                <td><?= htmlspecialchars($stage['stage_name']) ?></td>
                <td><?= htmlspecialchars($stage['status']) ?></td>
                <td>
                    <?php if ($is_my_stage && $stage['status'] === 'Pending'): ?>
                        <form method="post" action="assign_stage.php">
                            <input type="hidden" name="stage_id" value="<?= $stage['id'] ?>">
                            <input type="hidden" name="action" value="start">
                            <button type="submit">Start</button>
                        </form>
                    <?php elseif ($is_my_stage && $stage['status'] === 'In Progress'): ?>
                        <form method="post" action="assign_stage.php">
                            <input type="hidden" name="stage_id" value="<?= $stage['id'] ?>">
                            <input type="hidden" name="action" value="complete">
                            <button type="submit">Complete</button>
                        </form>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
<?php endforeach; ?>
