<?php
session_start();
include 'db.php';

$staff_id = $_SESSION['staff_id'] ?? null;
$branch = $_SESSION['branch'] ?? null;

if (!$staff_id || !$branch) die("Login required");

$job_card_id = $_GET['job_id'] ?? null;
if (!$job_card_id) die("Invalid job card ID");

// Fetch job info
$stmt = $conn->prepare("SELECT * FROM job_cards WHERE id=? AND branch=?");
$stmt->bind_param("is", $job_card_id, $branch);
$stmt->execute();
$job = $stmt->get_result()->fetch_assoc();
$stmt->close();
if (!$job) die("Job card not found");

// Fetch stages assigned to this staff
$stmt = $conn->prepare("SELECT * FROM job_card_stages WHERE job_card_id=? AND FIND_IN_SET(?, assigned_to) ORDER BY id ASC");
$stmt->bind_param("ii", $job_card_id, $staff_id);
$stmt->execute();
$stages = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Job Card <?= htmlspecialchars($job['job_card_number']) ?> - Stages</title>
</head>
<body>
<h1>Job Card: <?= htmlspecialchars($job['job_card_number']) ?></h1>

<table border="1" cellpadding="5">
    <tr>
        <th>Stage</th>
        <th>Status</th>
        <th>Started At</th>
        <th>Completed At</th>
        <th>Remarks</th>
        <th>Action</th>
    </tr>
    <?php foreach ($stages as $s): ?>
        <tr>
            <form method="post" action="update_stage.php">
                <input type="hidden" name="job_card_id" value="<?= $job_card_id ?>">
                <input type="hidden" name="stage_id" value="<?= $s['id'] ?>">
                <td><?= htmlspecialchars($s['stage_name']) ?></td>
                <td>
                    <select name="status">
                        <option value="Pending" <?= $s['status']=='Pending'?'selected':'' ?>>Pending</option>
                        <option value="In Progress" <?= $s['status']=='In Progress'?'selected':'' ?>>In Progress</option>
                        <option value="Completed" <?= $s['status']=='Completed'?'selected':'' ?>>Completed</option>
                    </select>
                </td>
                <td><?= htmlspecialchars($s['started_at'] ?? '') ?></td>
                <td><?= htmlspecialchars($s['completed_at'] ?? '') ?></td>
                <td><input type="text" name="remarks" value="<?= htmlspecialchars($s['remarks']) ?>"></td>
                <td><button type="submit">Update</button></td>
            </form>
        </tr>
    <?php endforeach; ?>
</table>
<a href="staff_dashboard.php">Back to Dashboard</a>
</body>
</html>
