<?php
session_start();
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) die("Connection failed: " . $mysqli->connect_error);

$filter_branch = $_GET['branch'] ?? '';
$allowed_branches = ['Jwaneng', 'Letlhakane'];
$filter_branch = ucfirst(strtolower(trim($filter_branch)));

$sql = "SELECT u.id AS user_id, u.username, u.role, u.branch, u.created_at,
        e.id AS emp_id, e.department, e.position, e.is_supervisor, e.status, e.email, e.phone
        FROM users u
        JOIN employees e ON LOWER(u.username) = LOWER(e.employee_name)
        WHERE e.is_supervisor = 1";

$params = [];
$types = '';

if ($filter_branch && in_array($filter_branch, $allowed_branches)) {
    $sql .= " AND u.branch = ?";
    $params[] = $filter_branch;
    $types .= 's';
}

$sql .= " ORDER BY u.username ASC";

$stmt = $mysqli->prepare($sql);
if (!$stmt) die("Prepare failed: " . $mysqli->error);

if ($params) $stmt->bind_param($types, ...$params);

$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head><title>Supervisors</title></head>
<body>
<h2>Supervisors</h2>

<form method="GET">
    Filter by Branch:
    <select name="branch" onchange="this.form.submit()">
        <option value="" <?= $filter_branch === '' ? 'selected' : '' ?>>-- All --</option>
        <?php foreach ($allowed_branches as $branch): ?>
            <option value="<?= htmlspecialchars($branch) ?>" <?= $filter_branch === $branch ? 'selected' : '' ?>><?= htmlspecialchars($branch) ?></option>
        <?php endforeach; ?>
    </select>
</form>

<table border="1" cellpadding="5" cellspacing="0">
    <thead>
    <tr>
        <th>Username</th><th>Role</th><th>Branch</th><th>Department</th><th>Position</th><th>Status</th><th>Email</th><th>Phone</th><th>Actions</th>
    </tr>
    </thead>
    <tbody>
    <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($row['username']) ?></td>
            <td><?= htmlspecialchars($row['role']) ?></td>
            <td><?= htmlspecialchars($row['branch']) ?></td>
            <td><?= htmlspecialchars($row['department']) ?></td>
            <td><?= htmlspecialchars($row['position']) ?></td>
            <td><?= htmlspecialchars($row['status']) ?></td>
            <td><?= htmlspecialchars($row['email']) ?></td>
            <td><?= htmlspecialchars($row['phone']) ?></td>
            <td>
                <a href="edit_user.php">Edit</a> |
                <a href="delete_supervisor.php?user_id=<?= $row['user_id'] ?>&emp_id=<?= $row['emp_id'] ?>" onclick="return confirm('Delete this supervisor?')">Delete</a>
            </td>
        </tr>
    <?php endwhile; ?>
    </tbody>
</table>

<p><a href="add_user.php">➕ Add New Supervisor</a></p>
</body>
</html>
