<?php
session_start();
include 'db.php';

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES["note_file"]) && isset($_POST["job_card_id"])) {
    $jobCardId = intval($_POST["job_card_id"]);

    // Check if a delivery note already exists for this job card
    $checkStmt = $conn->prepare("SELECT COUNT(*) AS count FROM delivery_notes WHERE job_card_id = ?");
    $checkStmt->bind_param("i", $jobCardId);
    $checkStmt->execute();
    $resultCheck = $checkStmt->get_result()->fetch_assoc();
    $checkStmt->close();

    if ($resultCheck['count'] > 0) {
        $_SESSION['error'] = "Delivery note has already been uploaded for this job. Upload not allowed.";
        header("Location: view_job.php?id=" . $jobCardId);
        exit();
    }

    $uploadedBy = $_SESSION["username"] ?? "Unknown";

    // File details
    $file = $_FILES["note_file"];
    $fileName = basename($file["name"]);
    $fileTmpPath = $file["tmp_name"];
    $fileError = $file["error"];
    $fileSize = $file["size"];

    $allowedExtensions = ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png'];
    $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if ($fileError === UPLOAD_ERR_OK && in_array($ext, $allowedExtensions)) {
        $newFileName = time() . "_" . preg_replace("/[^a-zA-Z0-9\._-]/", "_", $fileName);
        $uploadPath = "uploads/" . $newFileName;

        if (move_uploaded_file($fileTmpPath, $uploadPath)) {
            $stmt = $conn->prepare("INSERT INTO delivery_notes (job_card_id, note_file, uploaded_at, uploaded_by) VALUES (?, ?, NOW(), ?)");
            $stmt->bind_param("iss", $jobCardId, $uploadPath, $uploadedBy);

            if ($stmt->execute()) {
                $update = $conn->prepare("UPDATE job_cards SET status = 'closed', completed_date = NOW() WHERE id = ?");
                $update->bind_param("i", $jobCardId);
                $update->execute();

                $_SESSION['message'] = "Delivery note uploaded successfully and job marked as closed.";
                header("Location: view_job.php?id=" . $jobCardId);
                exit();
            } else {
                $_SESSION['error'] = "Error saving delivery note to database.";
                header("Location: view_job.php?id=" . $jobCardId);
                exit();
            }
        } else {
            $_SESSION['error'] = "Failed to move uploaded file.";
            header("Location: view_job.php?id=" . $jobCardId);
            exit();
        }
    } else {
        $_SESSION['error'] = "Invalid file or upload error.";
        header("Location: view_job.php?id=" . $jobCardId);
        exit();
    }
} else {
    $_SESSION['error'] = "No file or job card ID received.";
    header("Location: view_job.php");
    exit();
}
?>
