<?php
session_start();
include 'db.php';

$staff_id = $_SESSION['staff_id'] ?? null;
$branch = $_SESSION['branch'] ?? null;

if (!$staff_id || !$branch) die("Login required");

$stage_id = $_POST['stage_id'] ?? null;
$job_card_id = $_POST['job_card_id'] ?? null;
$status = $_POST['status'] ?? 'Pending';
$remarks = $_POST['remarks'] ?? '';

if (!$stage_id || !$job_card_id) die("Invalid request");

// Only allow staff assigned to stage to update
$stmt = $conn->prepare("SELECT assigned_to, status FROM job_card_stages WHERE id=? AND job_card_id=?");
$stmt->bind_param("ii", $stage_id, $job_card_id);
$stmt->execute();
$stage = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$stage || !in_array($staff_id, explode(',', $stage['assigned_to']))) die("Access denied");

// Update timestamps automatically
$started_at = $stage['status'] == 'Pending' && $status != 'Pending' ? date('Y-m-d H:i:s') : $stage['started_at'];
$completed_at = $status == 'Completed' && $stage['status'] != 'Completed' ? date('Y-m-d H:i:s') : $stage['completed_at'];

$upd = $conn->prepare("UPDATE job_card_stages SET status=?, remarks=?, started_at=?, completed_at=? WHERE id=?");
$upd->bind_param("ssssi", $status, $remarks, $started_at, $completed_at, $stage_id);
$upd->execute();
$upd->close();

header("Location: worker_stages.php?job_id=$job_card_id");
exit;
