<?php
session_start();
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");

if ($mysqli->connect_errno) {
    die("Database connection failed: " . $mysqli->connect_error);
}

// Ensure staff is logged in
if (!isset($_SESSION['staff_id'])) {
    header("Location: login.php");
    exit;
}

$staff_id = $_SESSION['staff_id'];
$branch = $_SESSION['branch'] ?? '';

// Check that the logged-in user is not a supervisor
$checkStmt = $mysqli->prepare("SELECT is_supervisor, employee_name FROM employees WHERE id = ? AND branch = ?");
$checkStmt->bind_param("is", $staff_id, $branch);
$checkStmt->execute();
$checkResult = $checkStmt->get_result()->fetch_assoc();
$checkStmt->close();

if (!$checkResult || $checkResult['is_supervisor']) {
    die("Access denied. Supervisors cannot log in here.");
}

$staff_name = $checkResult['employee_name'];

// Get job cards assigned to this staff member
$query = "
SELECT DISTINCT jc.id, jc.job_card_number, jc.customer_name, jc.order_description
FROM job_cards jc
JOIN job_card_stages jcs ON jc.id = jcs.job_card_id
WHERE FIND_IN_SET(?, jcs.assigned_to) > 0
AND jc.branch = ?
ORDER BY jc.id ASC
";

$stmt = $mysqli->prepare($query);
if (!$stmt) {
    die("Prepare failed: " . $mysqli->error);
}

$stmt->bind_param("is", $staff_id, $branch);
$stmt->execute();
$result = $stmt->get_result();
$job_cards = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Staff Dashboard</title>
    <style>
        body { font-family: Arial, sans-serif; margin:20px; background:#f7f7f7; }
        table { border-collapse: collapse; width: 100%; margin-bottom: 20px; background:#fff; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align:left; }
        th { background: #30307d; color: #fff; }
        button { padding: 6px 12px; background:#30307d; color:#fff; border:none; border-radius:6px; cursor:pointer; }
        button:hover { background:#1e1e5c; }
    </style>
</head>
<body>
<h2>Welcome, <?= htmlspecialchars($staff_name) ?></h2>

<?php if (empty($job_cards)): ?>
    <p>No job cards assigned to you at this branch.</p>
<?php else: ?>
    <table>
        <tr>
            <th>Job Card Number</th>
            <th>Customer Name</th>
            <th>Order Description</th>
            <th>Action</th>
        </tr>
        <?php foreach ($job_cards as $jc): ?>
            <tr>
                <td><?= htmlspecialchars($jc['job_card_number']) ?></td>
                <td><?= htmlspecialchars($jc['customer_name']) ?></td>
                <td><?= htmlspecialchars($jc['order_description']) ?></td>
                <td>
                    <form action="view_job_card.php" method="GET" style="margin:0;">
                        <input type="hidden" name="id" value="<?= $jc['id'] ?>">
                        <button type="submit">View</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
<?php endif; ?>
</body>
</html>
