<?php
session_start();
$branch = $_SESSION['branch'] ?? null;
if (!$branch) {
    die("User branch not defined.");
}

$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Database connection failed: " . $mysqli->connect_error);
}

// Handle AJAX request to update contact person or tel
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    $id = (int)$_POST['id'];
    $contact_person = trim($_POST['contact_person']);
    $telephone = trim($_POST['telephone']);

    if ($contact_person === '' || $telephone === '') {
        echo json_encode(['success' => false, 'error' => 'Contact Person and Telephone cannot be empty.']);
        exit;
    }

    $stmt = $mysqli->prepare("UPDATE job_cards SET contact_person = ?, telephone = ? WHERE id = ? AND branch = ?");
    $stmt->bind_param("ssis", $contact_person, $telephone, $id, $branch);
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => $stmt->error]);
    }
    $stmt->close();
    exit;
}

// Fetch jobs only for this branch
$sql = "SELECT id, job_card_number, customer_name, order_description, completed_date, invoice_number, contact_person, telephone 
        FROM job_cards 
        WHERE status = 'closed' AND invoiced = 1 AND branch = ?
        ORDER BY completed_date DESC";

$stmt = $mysqli->prepare($sql);
$stmt->bind_param('s', $branch);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Closed & Invoiced Jobs - Branch <?= htmlspecialchars(ucwords($branch)) ?> | Dashboard | Invoices</title>
    <link rel="stylesheet" href="style.css" />
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f5f7fa;
            color: #30307d;
        }
        h1 {
            margin-bottom: 20px;
        }
        nav {
            margin-bottom: 20px;
        }
        nav a {
            margin-right: 15px;
            text-decoration: none;
            font-weight: bold;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            background: white;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
        }
        th, td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #30307d;
            color: white;
        }
        a.button {
            background-color: #de1a1c;
            color: white;
            padding: 6px 12px;
            text-decoration: none;
            border-radius: 4px;
            display: inline-block;
        }
        a.button:hover {
            background-color: #b51719;
        }
        input[type="text"] {
            width: 100%;
            padding: 4px;
            box-sizing: border-box;
            font-size: 14px;
        }
        button.save-btn {
            background-color: #30307D;
            color: white;
            padding: 5px 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        button.save-btn:hover {
            background-color: #2a2a6d;
        }
        button.save-btn:disabled {
            background-color: #888;
            cursor: not-allowed;
        }
        .status-msg {
            color: #de1a1c;
            font-size: 8px;
            margin-top: 4px;
            min-height: 10px;
        }
    </style>
</head>
<body>

<h2>Closed & Invoiced Jobs </h2>

<nav>
    <a href="index.php">Dashboard</a>
    <a href="Insert.php">Add job cards</a>
</nav>

<table>
    <thead>
    <tr>
        <th>Job Card Number</th>
        <th>Customer Name</th>
        <th>Order Description</th>
        <th>Completed Date</th>
        <th>Invoice Number</th>
        <th>Delivery Note</th>
        <th>Contact Person</th>
        <th>Tel</th>
        <th>Save</th>
    </tr>
    </thead>
    <tbody>
    <?php if ($result->num_rows === 0): ?>
        <tr><td colspan="9">No closed & invoiced jobs found for this branch.</td></tr>
    <?php else: ?>
        <?php while ($row = $result->fetch_assoc()):
            $disabled = (!empty($row['contact_person']) || !empty($row['telephone'])) ? 'disabled' : '';
            $btn_disabled = $disabled ? 'disabled' : '';
            ?>
            <tr id="row-<?= $row['id'] ?>">
                <td><?= htmlspecialchars($row['job_card_number']) ?></td>
                <td><?= htmlspecialchars($row['customer_name']) ?></td>
                <td><?= htmlspecialchars($row['order_description']) ?></td>
                <td><?= htmlspecialchars($row['completed_date']) ?></td>
                <td><?= htmlspecialchars($row['invoice_number']) ?></td>
                <td>
                    <a class="button" href="generate_note.php?id=<?= (int)$row['id'] ?>" target="_blank"
                       onclick="return checkGenerate(<?= $row['id'] ?>)">
                        Generate Note
                    </a>
                </td>
                <td>
                    <input type="text" name="contact_person" value="<?= htmlspecialchars($row['contact_person']) ?>" id="contact_person_<?= $row['id'] ?>" <?= $disabled ?>>
                </td>
                <td>
                    <input type="text" name="telephone" value="<?= htmlspecialchars($row['telephone']) ?>" id="telephone_<?= $row['id'] ?>" <?= $disabled ?>>
                </td>
                <td>
                    <button class="save-btn" onclick="saveRow(<?= $row['id'] ?>)" <?= $btn_disabled ?>>Save</button>
                    <div id="status-<?= $row['id'] ?>" class="status-msg"></div>
                </td>
            </tr>
        <?php endwhile; ?>
    <?php endif; ?>
    </tbody>
</table>

<script>
    function saveRow(id) {
        const contactPersonInput = document.getElementById('contact_person_' + id);
        const telephoneInput = document.getElementById('telephone_' + id);
        const saveBtn = document.querySelector('#row-' + id + ' .save-btn');
        const statusBox = document.getElementById('status-' + id);

        if (contactPersonInput.value.trim() === '' || telephoneInput.value.trim() === '') {
            alert('Please fill in Contact Person and Tel before saving.');
            return;
        }

        saveBtn.disabled = true;
        statusBox.textContent = 'Saving...';
        statusBox.style.color = '#30307d';

        fetch('', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams({
                ajax: 1,
                id: id,
                contact_person: contactPersonInput.value,
                telephone: telephoneInput.value
            })
        })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    statusBox.textContent = 'Saved!';
                    statusBox.style.color = 'green';

                    contactPersonInput.disabled = true;
                    telephoneInput.disabled = true;
                    saveBtn.disabled = true;
                } else {
                    statusBox.textContent = 'Error: ' + (data.error || 'Unknown error');
                    statusBox.style.color = 'red';
                    saveBtn.disabled = false;
                }
                setTimeout(() => statusBox.textContent = '', 3000);
            })
            .catch(() => {
                statusBox.textContent = 'Network error';
                statusBox.style.color = 'red';
                saveBtn.disabled = false;
                setTimeout(() => statusBox.textContent = '', 3000);
            });
    }

    function checkGenerate(id) {
        const contactPerson = document.getElementById('contact_person_' + id).value.trim();
        const telephone = document.getElementById('telephone_' + id).value.trim();

        if (contactPerson === '' || telephone === '') {
            alert('Please fill in Contact Person and Tel before generating the delivery note.');
            return false;
        }
        return true;
    }
</script>

</body>
</html>

<?php
$stmt->close();
$mysqli->close();
?>
