<?php
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect to MySQL: " . $mysqli->connect_error);
}

$quote_id = filter_input(INPUT_GET, 'quote_id', FILTER_VALIDATE_INT);
if (!$quote_id) {
    die("Invalid quote ID.");
}

// Update quote status if form submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['status'])) {
    $status = $_POST['status'];
    $allowed_statuses = ['created', 'waiting', 'with_client', 'not_taken_up', 'successful'];
    if (in_array($status, $allowed_statuses)) {
        $update_stmt = $mysqli->prepare("UPDATE quotes SET status = ? WHERE id = ?");
        $update_stmt->bind_param("si", $status, $quote_id);
        $update_stmt->execute();
        $update_stmt->close();
        header("Location: quote_detail.php?quote_id=$quote_id&updated=1");
        exit;
    }
}

// Fetch quote info
$stmt = $mysqli->prepare("SELECT * FROM quotes WHERE id = ?");
$stmt->bind_param("i", $quote_id);
$stmt->execute();
$quote = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$quote) {
    die("Quote not found.");
}

// Fetch quote items for display
$item_sql = "SELECT description FROM quote_items WHERE quote_id = ?";
$item_stmt = $mysqli->prepare($item_sql);
$item_stmt->bind_param("i", $quote_id);
$item_stmt->execute();
$item_result = $item_stmt->get_result();

$items = [];
while ($item = $item_result->fetch_assoc()) {
    $items[] = $item['description'];
}
$item_stmt->close();

$status_options = [
    'created' => 'Created',
    'waiting' => 'Waiting for Outsourced Prices',
    'with_client' => 'With Client',
    'not_taken_up' => 'Not Taken Up',
    'successful' => 'Successful'
];

?>

<!DOCTYPE html>

<html lang="en">
<link rel="stylesheet" href="style.css">

<head>
    <meta charset="UTF-8" />
    <title>Quote Details - <?= htmlspecialchars($quote['quote_number']) ?></title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 700px; margin: auto; padding: 20px; }
        label { font-weight: bold; }
        select, button { padding: 5px; margin-top: 10px; }
        .success { color: green; margin-bottom: 15px; }
    </style>
</head>
<body>

<h1>Quote <?= htmlspecialchars($quote['quote_number']) ?></h1>
<p><strong>Date:</strong> <?= htmlspecialchars($quote['quote_date']) ?></p>
<p><strong>Items:</strong> <?= htmlspecialchars(implode(", ", $items)) ?></p>

<?php if (isset($_GET['updated'])): ?>
    <p class="success">Status updated successfully.</p>
<?php endif; ?>

<form method="POST">
    <label for="status">Status:</label><br />
    <select name="status" id="status">
        <?php foreach ($status_options as $key => $label): ?>
            <option value="<?= $key ?>" <?= ($quote['status'] === $key) ? 'selected' : '' ?>><?= $label ?></option>
        <?php endforeach; ?>
    </select><br />
    <button type="submit">Update Status</button>
</form>

<p><a href="customer_details.php?customer_id=<?= urlencode($quote['customer_id']) ?>">← Back to Customer Details</a></p>

</body>
</html>
