<?php
session_start();

if (!isset($_SESSION['username']) || !isset($_SESSION['branch'])) {
    header("Location: login.php");
    exit();
}

$branch = $_SESSION['branch'];
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");

if ($mysqli->connect_errno) {
    die("Database connection failed: " . $mysqli->connect_error);
}

// Fetch branch-specific job card data
$stats = [
    'open' => 0,
    'closed' => 0,
    'due_today' => 0,
    'completed_today' => 0,
];

$job_query = $mysqli->prepare("SELECT status, DATE(due_date) = CURDATE() AS due_today, DATE(closed_at) = CURDATE() AS completed_today FROM job_cards WHERE branch = ?");
$job_query->bind_param("s", $branch);
$job_query->execute();
$result = $job_query->get_result();

while ($row = $result->fetch_assoc()) {
    if ($row['status'] === 'open') $stats['open']++;
    if ($row['status'] === 'closed') $stats['closed']++;
    if ($row['due_today']) $stats['due_today']++;
    if ($row['completed_today']) $stats['completed_today']++;
}
$job_query->close();

// Fetch delivery updates per department for this branch
$delivery_data = [];
$departments = ['Bulk Printing', 'Signage', 'Commercial Branding'];

foreach ($departments as $dept) {
    $stmt = $mysqli->prepare("
        SELECT COUNT(*) as total,
               SUM(CASE WHEN status = 'delivered' THEN 1 ELSE 0 END) as delivered,
               SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
               SUM(CASE WHEN due_date < CURDATE() AND status != 'delivered' THEN 1 ELSE 0 END) as due
        FROM job_cards
        WHERE department = ? AND branch = ?
    ");
    $stmt->bind_param("ss", $dept, $branch);
    $stmt->execute();
    $stmt->bind_result($total, $delivered, $pending, $due);
    $stmt->fetch();
    $stmt->close();

    $percentage = $total > 0 ? round(($delivered / $total) * 100) : 0;
    $delivery_data[] = [
        'department' => $dept,
        'total' => $total,
        'delivered' => $delivered,
        'pending' => $pending,
        'due' => $due,
        'percentage' => $percentage,
    ];
}
?>

<!DOCTYPE html>
<html>
<head>
    <title><?= htmlspecialchars($branch) ?> Dashboard - Masteka Printing</title>
    <style>
        body { font-family: Arial; margin: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
        h2 { color: #30307d; }
    </style>
</head>
<body>

<h1>Masteka Printing Production</h1>
<h2><?= htmlspecialchars($branch) ?> Dashboard</h2>

<p><a href="logout.php">Logout</a></p>

<div>
    <p><strong>Open Job Cards:</strong> <?= $stats['open'] ?></p>
    <p><strong>Closed Job Cards:</strong> <?= $stats['closed'] ?></p>
    <p><strong>Due Orders:</strong> <?= $stats['due_today'] ?></p>
    <p><strong>Completed Today:</strong> <?= $stats['completed_today'] ?></p>
</div>

<h3>Delivery Updates</h3>
<table>
    <thead>
    <tr>
        <th>Department</th>
        <th>Orders</th>
        <th>Delivered</th>
        <th>Pending</th>
        <th>Due</th>
        <th>Status</th>
    </tr>
    </thead>
    <tbody>
    <?php foreach ($delivery_data as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['department']) ?></td>
            <td><?= $row['total'] ?></td>
            <td><?= $row['delivered'] ?></td>
            <td><?= $row['pending'] ?></td>
            <td><?= $row['due'] ?></td>
            <td><?= $row['percentage'] ?>%</td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

</body>
</html>
