<?php
session_start();

if (isset($_SESSION['user_id'])) {
    $userId = $_SESSION['user_id'];

    // Connect to DB
    $mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
    if ($mysqli->connect_errno) {
        die("DB connection failed: " . $mysqli->connect_error);
    }

    // Clear remember_token from DB for this user
    $stmt = $mysqli->prepare("UPDATE users SET remember_token = NULL WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $stmt->close();
    }

    $mysqli->close();
}

// Clear remember_me cookie by setting expiry in the past
setcookie('remember_me', '', time() - 3600, "/");

// Destroy all session data
$_SESSION = [];
session_destroy();

// Redirect to login page (or home)
header("Location: login.php");
exit;
