<?php
session_start();

// --- Database connection ---
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Database connection failed: " . $mysqli->connect_error);
}

// --- Initialize variables ---
$login_error = '';
$branch = $_POST['branch'] ?? '';
$type = $_POST['login_type'] ?? ''; // 'user' or 'staff'
$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';
$remember = isset($_POST['remember']);

// ------------------ Auto-login via remember_me cookie ------------------
if (!isset($_SESSION['user_id']) && !isset($_SESSION['staff_id']) && isset($_COOKIE['remember_me'])) {
    $token = $_COOKIE['remember_me'];

    // Try staff first
    $stmt = $mysqli->prepare("SELECT id, username, password, status, branch 
                              FROM staff 
                              WHERE remember_token = ? AND position = 'Staff'");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $stmt->bind_result($staff_id, $username_db, $hashed_pw, $status, $db_branch);
    if ($stmt->fetch()) {
        $_SESSION['staff_id'] = $staff_id;
        $_SESSION['username'] = $username_db;
        $_SESSION['branch'] = $db_branch;
        header("Location: staff_dashboard.php");
        exit;
    }
    $stmt->close();

    // Then users
    $stmt = $mysqli->prepare("SELECT id, username, role, branch FROM users WHERE remember_token = ?");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $stmt->bind_result($user_id, $username_db, $role, $db_branch);
    if ($stmt->fetch()) {
        $_SESSION['user_id'] = $user_id;
        $_SESSION['username'] = $username_db;
        $_SESSION['role'] = $role;
        $_SESSION['branch'] = $db_branch;
        $_SESSION['department'] = $role;

        $dashboardLinks = [
            'sales' => 'insert.php',
            'accounts' => 'Accounts.php',
            'admin' => 'dashboard.php',
            'Bulk Printing' => 'Admins.php',
            'Signage' => 'Admins.php',
            'Commercial Branding' => 'Admins.php',
        ];
        header("Location: " . ($dashboardLinks[$role] ?? 'dashboard.php'));
        exit;
    }
    $stmt->close();
}

// ------------------ Handle login submission ------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {

    if ($type === 'staff') {
        $stmt = $mysqli->prepare("SELECT id, username, password, status, branch, position 
                                  FROM staff 
                                  WHERE username = ? AND position = 'Staff'");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->bind_result($staff_id, $username_db, $hashed_pw, $status, $db_branch, $position);

        if ($stmt->fetch()) {
            if ($status !== 'Active') {
                $login_error = "Your account is inactive.";
            } elseif (strtolower(trim($branch)) !== strtolower(trim($db_branch))) {
                $login_error = "Branch mismatch.";
            } elseif (password_verify($password, $hashed_pw)) {
                $_SESSION['staff_id'] = $staff_id;
                $_SESSION['username'] = $username_db;
                $_SESSION['branch'] = $db_branch;

                if ($remember) {
                    $token = bin2hex(random_bytes(32));
                    setcookie('remember_me', $token, time() + (86400 * 30), "/", "", false, true);
                    $update = $mysqli->prepare("UPDATE staff SET remember_token = ? WHERE id = ?");
                    $update->bind_param("si", $token, $staff_id);
                    $update->execute();
                    $update->close();
                }

                header("Location: staff_dashboard.php");
                exit;
            } else {
                $login_error = "Invalid password.";
            }
        } else {
            $login_error = "Invalid staff credentials.";
        }
        $stmt->close();

    } elseif ($type === 'user') {
        $stmt = $mysqli->prepare("SELECT id, password, role, branch FROM users WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->bind_result($user_id, $hashed_pw, $role, $db_branch);

        if ($stmt->fetch() && password_verify($password, $hashed_pw)) {
            if (strtolower($db_branch) === strtolower($branch) || $role === 'admin') {
                $_SESSION['user_id'] = $user_id;
                $_SESSION['username'] = $username;
                $_SESSION['role'] = $role;
                $_SESSION['branch'] = $db_branch;
                $_SESSION['department'] = $role;

                if ($remember) {
                    $token = bin2hex(random_bytes(32));
                    setcookie('remember_me', $token, time() + (86400 * 30), "/", "", false, true);
                    $update = $mysqli->prepare("UPDATE users SET remember_token = ? WHERE id = ?");
                    $update->bind_param("si", $token, $user_id);
                    $update->execute();
                    $update->close();
                }

                $dashboardLinks = [
                    'sales' => 'insert.php',
                    'accounts' => 'Accounts.php',
                    'admin' => 'dashboard.php',
                    'Bulk Printing' => 'Admins.php',
                    'Signage' => 'Admins.php',
                    'Commercial Branding' => 'Admins.php',
                ];
                header("Location: " . ($dashboardLinks[$role] ?? 'dashboard.php'));
                exit;
            } else {
                $login_error = "You don't have access to this branch";
            }
        } else {
            $login_error = "Invalid username or password";
        }
        $stmt->close();

    } else {
        $login_error = "Please select login type.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Login - Masteka</title>
    <style>
        body { font-family: Arial,sans-serif; display:flex; justify-content:center; align-items:center; height:100vh; margin:0; background:#eef6fc; }
        .container { background:#fff; padding:40px; border-radius:12px; box-shadow:0 4px 15px rgba(48,48,125,0.2); width:360px; text-align:center; }
        .logo img { max-width:150px; margin-bottom:20px; }
        input[type=text], input[type=password], select { width:100%; padding:12px; margin:10px 0; border:2px solid #ddd; border-radius:8px; box-sizing:border-box; }
        input[type=text]:focus, input[type=password]:focus, select:focus { outline:none; border-color:#30307d; }
        button { width:100%; padding:12px; border:none; border-radius:8px; background:#30307d; color:#fff; font-weight:600; cursor:pointer; margin-top:15px; }
        button:hover { background:#1e1e5c; }
        p.error { color:#de1a1c; font-weight:600; margin-top:10px; }
        .switch { display:flex; justify-content:center; margin-bottom:15px; }
        .switch label { margin:0 10px; cursor:pointer; font-weight:600; }
    </style>
</head>
<body>
<div class="container">
    <div class="logo"><img src="Images/lgo.png" alt="Logo" /></div>
    <form method="POST">
        <div class="switch">
            <label><input type="radio" name="login_type" value="user" <?= ($type==='user')?'checked':'' ?> /> User</label>
            <label><input type="radio" name="login_type" value="staff" <?= ($type==='staff')?'checked':'' ?> /> Staff</label>
        </div>
        <input type="text" name="username" placeholder="Username" value="<?= htmlspecialchars($username) ?>" required />
        <input type="password" name="password" placeholder="Password" required />
        <select name="branch" required>
            <option value="" disabled <?= $branch===''?'selected':'' ?>>Select Branch</option>
            <option value="Jwaneng" <?= ($branch==='Jwaneng')?'selected':'' ?>>Jwaneng</option>
            <option value="Letlhakane" <?= ($branch==='Letlhakane')?'selected':'' ?>>Letlhakane</option>
        </select>
        <label><input type="checkbox" name="remember" <?= $remember?'checked':'' ?> /> Remember me</label>
        <button type="submit" name="login">Login</button>
        <?php if($login_error): ?><p class="error"><?= htmlspecialchars($login_error) ?></p><?php endif; ?>
    </form>
</div>
</body>
</html>
