<?php
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect: " . $mysqli->connect_error);
}

$result = $mysqli->query("SELECT * FROM job_cards ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Job Cards List</title>
    <style>
        body { font-family: Arial,sans-serif; padding: 20px; background: #eef6fc; }
        table { border-collapse: collapse; width: 100%; background: white; }
        th, td { border: 1px solid #ccc; padding: 10px; text-align: center; }
        th { background: #30307d; color: white; }
        input, select { width: 80px; padding: 5px; }
        button { background: #30307d; color: white; border: none; padding: 5px 10px; border-radius: 5px; cursor: pointer; }
        .message { margin-bottom: 15px; padding: 10px; background: #d4edda; border: 1px solid #c3e6cb; color: #155724; border-radius: 5px; }
        nav a { margin-right: 15px; }
        button{
            background: #30307d;
            color: white;
            border: none;
            padding: 8px 14px;
            border-radius: 6px;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        button:hover {
            background: #1f1f5c;
        }
        nav {
            margin-bottom: 20px;
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        nav a {
            display: inline-block;
            background-color: #30307d;
            color: white;
            text-decoration: none;
            padding: 10px 16px;
            border-radius: 6px;
            font-weight: bold;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }

        nav a:hover {
            background-color: #1f1f5c;
            transform: translateY(-2px);
        }


    </style>
</head>
<body>


<h1>Job Cards List</h1>
<nav>
    <a href="index.php">Production</a>
    <a href="Insert.php">DashBoard</a>
    <a href="job_cards_list.php">Job Cards</a>
    <a href="delivery_updates_list.php">Delivery Updates</a>
    <a href="team_hours_list.php">Team Hours</a>
</nav>


<table>
    <thead>
    <tr>
        <th>Job Card Number</th><th>Status</th><th>Due Date</th><th>Completed Date</th><th>Edit</th>
    </tr>
    </thead>
    <tbody>
    <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($row['job_card_number']) ?></td>
            <td><?= htmlspecialchars($row['status']) ?></td>
            <td><?= htmlspecialchars($row['due_date']) ?></td>
            <td><?= htmlspecialchars($row['completed_date']) ?></td>
            <td><a href="edit_job_card.php?id=<?= $row['id'] ?>">Edit</a></td>
        </tr>
    <?php endwhile; ?>
    </tbody>
</table>

</body>
</html>
