<?php
session_start();
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect to MySQL: " . $mysqli->connect_error);
}

$message = '';

// Fetch all distinct departments for filter dropdown
$departments = [];
$res = $mysqli->query("SELECT DISTINCT department FROM job_cards WHERE department IS NOT NULL ORDER BY department ASC");
while ($d = $res->fetch_assoc()) {
    $departments[] = $d['department'];
}

// Get selected department from GET param (or show all)
$selected_department = $_GET['department'] ?? 'all';

// Count total dispatched job cards
$dispatched_count = 0;
$res = $mysqli->query("SELECT COUNT(*) as total FROM job_cards WHERE dispatched = 1");
if ($res) {
    $row = $res->fetch_assoc();
    $dispatched_count = (int)$row['total'];
}

// Count total invoiced job cards
$invoiced_count = 0;
$res = $mysqli->query("SELECT COUNT(*) as total FROM job_cards WHERE invoiced = 1");
if ($res) {
    $row = $res->fetch_assoc();
    $invoiced_count = (int)$row['total'];
}

// Prepare query for invoiced job cards only
if ($selected_department === 'all') {
    $query = "SELECT id, job_card_number, customer_name, order_description, status, invoice_number, dispatched, department FROM job_cards WHERE invoiced = 1 ORDER BY due_date DESC";
    $stmt = $mysqli->prepare($query);
} else {
    $query = "SELECT id, job_card_number, customer_name, order_description, status, invoice_number, dispatched, department FROM job_cards WHERE invoiced = 1 AND department = ? ORDER BY due_date DESC";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('s', $selected_department);
}

$stmt->execute();
$result = $stmt->get_result();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Invoiced Job Cards</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #eef6fc;
            color: #30307d;
            padding: 20px;
        }
        h2 {
            margin-bottom: 5px;
        }
        p.stats {
            font-weight: bold;
            margin-top: 0;
            margin-bottom: 20px;
            color: #1a1a1a;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: left;
        }
        th {
            background-color: #30307d;
            color: white;
        }
        .status-dispatched {
            color: green;
            font-weight: bold;
        }
        .status-open {
            color: #f36e25;
            font-weight: bold;
        }
        .filter-form {
            margin-bottom: 20px;
        }
        select {
            padding: 6px;
            font-size: 1em;
        }
    </style>
</head>
<body>

<h2>Invoiced Job Cards</h2>
<p class="stats">Invoiced: <?= $invoiced_count ?> of <?= $dispatched_count ?> dispatched job cards.</p>

<form method="get" class="filter-form">
    <label for="department">Filter by Department:</label>
    <select name="department" id="department" onchange="this.form.submit()">
        <option value="all" <?= $selected_department === 'all' ? 'selected' : '' ?>>All Departments</option>
        <?php foreach ($departments as $dept): ?>
            <option value="<?= htmlspecialchars($dept) ?>" <?= $selected_department === $dept ? 'selected' : '' ?>>
                <?= htmlspecialchars($dept) ?>
            </option>
        <?php endforeach; ?>
    </select>
</form>

<?php if ($result->num_rows === 0): ?>
    <p>No invoiced job cards found<?= $selected_department !== 'all' ? " for department ".htmlspecialchars($selected_department) : "" ?>.</p>
<?php else: ?>
    <table>
        <thead>
        <tr>
            <th>Job Card Number</th>
            <th>Customer</th>
            <th>Description</th>
            <th>Department</th>
            <th>Status</th>
            <th>Invoice Number</th>
        </tr>
        </thead>
        <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
            <?php
            $status = $row['dispatched'] ? 'dispatched' : 'open';
            $status_class = $row['dispatched'] ? 'status-dispatched' : 'status-open';
            ?>
            <tr>
                <td><?= htmlspecialchars($row['job_card_number']) ?></td>
                <td><?= htmlspecialchars($row['customer_name']) ?></td>
                <td><?= htmlspecialchars($row['order_description']) ?></td>
                <td><?= htmlspecialchars($row['department']) ?></td>
                <td class="<?= $status_class ?>"><?= $status ?></td>
                <td><?= htmlspecialchars($row['invoice_number']) ?></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
<?php endif; ?>

</body>
</html>
