<?php
session_start();
include 'db.php';

$branch_filter = isset($_GET['branch']) ? mysqli_real_escape_string($conn, $_GET['branch']) : '';
$department_filter = isset($_GET['department']) ? mysqli_real_escape_string($conn, $_GET['department']) : '';

$query = "SELECT * FROM inventory_items WHERE 1";

if ($branch_filter !== '') {
    $query .= " AND branch = '$branch_filter'";
}
if ($department_filter !== '') {
    $query .= " AND department = '$department_filter'";
}

$result = mysqli_query($conn, $query);
if (!$result) {
    die("Database query failed: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Inventory List</title>
    <link rel="stylesheet" href= "styles.css" />
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background-color: #f2f2f2; }
        .low-stock { background-color: #f8d7da; }
    </style>
</head>
<body>
<h2>Inventory List</h2>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="inventory_list.php">Inventory List</a>
    <a href="insert.php">Add Job Card</a>

    <a href="inventory_add.php">Add Stock</a>

</nav>
<form method="GET">
    <label>Branch: </label>
    <select name="branch">
        <option value="">All</option>
        <option value="jwaneng" <?= strtolower($branch_filter) === 'jwaneng' ? 'selected' : '' ?>>Jwaneng</option>
        <option value="letlhakane" <?= strtolower($branch_filter) === 'letlhakane' ? 'selected' : '' ?>>Letlhakane</option>
    </select>

    <label>Department: </label>
    <select name="department">
        <option value="">All</option>
        <option value="Signage" <?= $department_filter === 'Signage' ? 'selected' : '' ?>>Signage</option>
        <option value="Bulk Printing" <?= $department_filter === 'Bulk Printing' ? 'selected' : '' ?>>Bulk Printing</option>
        <option value="Commercial Branding" <?= $department_filter === 'Commercial Branding' ? 'selected' : '' ?>>Commercial Branding</option>
    </select>

    <button type="submit">Filter</button>
</form>

<br />

<table>
    <thead>
    <tr>
        <th>Number</th>
        <th>Branch</th>
        <th>Department</th>
        <th>Process</th>
        <th>Name</th>
        <th>Unit</th>
        <th>Current Stock</th>
        <th>Minimum Stock</th>
        <th>Actions</th>
    </tr>
    </thead>
    <tbody>
    <?php while ($row = mysqli_fetch_assoc($result)): ?>
        <tr class="<?= ($row['current_stock'] <= $row['min_stock']) ? 'low-stock' : '' ?>">
            <td><?= htmlspecialchars($row['id']) ?></td>
            <td><?= htmlspecialchars(ucfirst($row['branch'])) ?></td>
            <td><?= htmlspecialchars($row['department']) ?></td>
            <td><?= htmlspecialchars($row['process'] ?? '-') ?></td>
            <td><?= htmlspecialchars($row['name']) ?></td>
            <td><?= htmlspecialchars($row['unit']) ?></td>
            <td><?= (int)$row['current_stock'] ?></td>
            <td><?= (int)$row['min_stock'] ?></td>
            <td>
                <a href="inventory_edit.php?id=<?= $row['id'] ?>">Edit</a> |
                <a href="inventory_delete.php?id=<?= $row['id'] ?>" onclick="return confirm('Delete this item?');">Delete</a>
            </td>
        </tr>
    <?php endwhile; ?>
    </tbody>
</table>
</body>
</html>
