<?php
session_start();
include 'db.php';

if (!isset($_GET['id'])) {
    die("No inventory item ID specified.");
}

$id = intval($_GET['id']);

$stmt = $conn->prepare("SELECT * FROM inventory_items WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$item = $result->fetch_assoc();

if (!$item) {
    die("Inventory item not found.");
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $branch = $_SESSION['branch'] ?? $item['branch'];

    $department = $_POST['department'];
    $process = $_POST['process'] ?? null;
    $name = $_POST['name'];
    $unit = $_POST['unit'];
    $current_stock = intval($_POST['current_stock']);
    $min_stock = intval($_POST['min_stock']);

    $updateStmt = $conn->prepare("UPDATE inventory_items SET branch = ?, department = ?, process = ?, name = ?, unit = ?, current_stock = ?, min_stock = ? WHERE id = ?");
    $updateStmt->bind_param("sssssiii", $branch, $department, $process, $name, $unit, $current_stock, $min_stock, $id);

    if ($updateStmt->execute()) {
        // Redirect immediately after successful update
        header("Location: inventory_list.php");
        exit;
    } else {
        $error = "Error updating item: " . $updateStmt->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Edit Inventory Item</title>
    <link rel="stylesheet" href="styles.css" />
</head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="inventory_list.php">Inventory List</a>
    <a href="insert.php">Add Job Cards</a>
    <a href="sales_jobs.php">Invoices</a>
</nav>

<h2>Edit Inventory Item</h2>

<?php if ($error): ?>
    <p style="color:red;"><?= htmlspecialchars($error) ?></p>
<?php endif; ?>

<form method="POST">
    <label>Branch:</label>
    <input type="text" value="<?= htmlspecialchars($item['branch']) ?>" disabled><br><br>

    <label>Department:</label>
    <select name="department" id="department" required>
        <option value="">Select Department</option>
        <option value="Signage" <?= $item['department'] === 'Signage' ? 'selected' : '' ?>>Signage</option>
        <option value="Bulk Printing" <?= $item['department'] === 'Bulk Printing' ? 'selected' : '' ?>>Bulk Printing</option>
        <option value="Commercial Branding" <?= $item['department'] === 'Commercial Branding' ? 'selected' : '' ?>>Commercial Branding</option>
    </select><br><br>

    <div id="process-container" style="display: <?= $item['department'] === 'Commercial Branding' ? 'block' : 'none' ?>;">
        <label>Process:</label>
        <select name="process">
            <option value="">Select Process</option>
            <option value="Engraving" <?= $item['process'] === 'Engraving' ? 'selected' : '' ?>>Engraving</option>
            <option value="Dye Sublimation" <?= $item['process'] === 'Dye Sublimation' ? 'selected' : '' ?>>Dye Sublimation</option>
            <option value="Embroidery" <?= $item['process'] === 'Embroidery' ? 'selected' : '' ?>>Embroidery</option>
        </select><br><br>
    </div>

    <label>Item Name:</label>
    <input type="text" name="name" value="<?= htmlspecialchars($item['name']) ?>" required><br><br>

    <label>Unit:</label>
    <input type="text" name="unit" value="<?= htmlspecialchars($item['unit']) ?>"><br><br>

    <label>Current Stock:</label>
    <input type="number" name="current_stock" value="<?= (int)$item['current_stock'] ?>" required><br><br>

    <label>Minimum Stock (alert level):</label>
    <input type="number" name="min_stock" value="<?= (int)$item['min_stock'] ?>"><br><br>

    <button type="submit">Update Item</button>
</form>

<script>
    document.getElementById('department').addEventListener('change', function() {
        let procContainer = document.getElementById('process-container');
        if (this.value === 'Commercial Branding') {
            procContainer.style.display = 'block';
        } else {
            procContainer.style.display = 'none';
        }
    });
</script>
</body>
</html>
