<?php
session_start();
include __DIR__ . '/db.php';

// Simulate logged-in user branch (replace this with your real login session branch)
if (!isset($_SESSION['branch'])) {
    $_SESSION['branch'] = 'jwaneng';  // example branch for logged-in user
}

$branch = $_SESSION['branch'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $department = $_POST['department'];
    $process = $_POST['process'] ?? null;
    $name = $_POST['name'];
    $unit = $_POST['unit'] ?: 'pcs';
    $qty = intval($_POST['current_stock']);
    $min_stock = intval($_POST['min_stock']);

    $stmt = $conn->prepare("INSERT INTO inventory_items (branch, department, process, name, unit, current_stock, min_stock) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssii", $branch, $department, $process, $name, $unit, $qty, $min_stock);

    if ($stmt->execute()) {
        // Redirect immediately after successful insert
        header("Location: inventory_list.php");
        exit;
    } else {
        echo "<p style='color:red;'>Error: " . $stmt->error . "</p>";
    }

}
?>
<link rel="stylesheet" href= "styles.css" />

<h2>Add Inventory Item</h2>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="inventory_list.php">Inventory List</a>
    <a href="insert.php">Add Job Cards</a>
    <a href="sales_jobs.php">Invoices</a>

</nav>

<form method="POST">
    <label>Branch:</label>
    <input type="text" value="<?= htmlspecialchars($branch) ?>" disabled><br><br>

    <label>Department:</label>
    <select name="department" id="department" required>
        <option value="">Select Department</option>
        <option value="Signage">Signage</option>
        <option value="Bulk Printing">Bulk Printing</option>
        <option value="Commercial Branding">Commercial Branding</option>
    </select><br><br>

    <div id="process-container" style="display:none;">
        <label>Process:</label>
        <select name="process">
            <option value="">Select Process</option>
            <option value="Engraving">Engraving</option>
            <option value="Dye Sublimation">Dye Sublimation</option>
            <option value="Embroidery">Embroidery</option>
        </select><br><br>
    </div>

    <label>Item Name:</label>
    <input type="text" name="name" required><br><br>

    <label>Unit:</label>
    <input type="text" name="unit" value="pcs"><br><br>

    <label>Initial Stock:</label>
    <input type="number" name="current_stock" required><br><br>

    <label>Minimum Stock (alert level):</label>
    <input type="number" name="min_stock" value="0"><br><br>

    <button type="submit">Add Item</button>
</form>

<script>
    document.getElementById('department').addEventListener('change', function() {
        const processContainer = document.getElementById('process-container');
        if (this.value === 'Commercial Branding') {
            processContainer.style.display = 'block';
        } else {
            processContainer.style.display = 'none';
        }
    });
</script>
