<?php
use fpdf\fpdf\FPDF;
session_start();
require('fpdf/fpdf.php');

$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) die("DB Connection failed: " . $mysqli->connect_error);

if(!isset($_GET['job_card_id']) || empty($_GET['job_card_id'])){
    die("Invalid Job Card ID.");
}

$job_card_id = intval($_GET['job_card_id']);

// Fetch job card
$jobCardResult = $mysqli->query("SELECT * FROM job_cards WHERE id = $job_card_id");
if($jobCardResult->num_rows == 0) die("Job Card not found.");
$job = $jobCardResult->fetch_assoc();

// Extend FPDF to add NbLines helper
class PDF extends FPDF {
    function NbLines($w, $txt){
        $cw = &$this->CurrentFont['cw'];
        if($w==0) $w = $this->w-$this->rMargin-$this->x;
        $wmax = ($w-2*$this->cMargin)*1000/$this->FontSize;
        $s = str_replace("\r",'',$txt);
        $nb = strlen($s);
        if($nb>0 && $s[$nb-1]=="\n") $nb--;
        $sep=-1;
        $i=0;
        $j=0;
        $l=0;
        $nl=1;
        while($i<$nb){
            $c=$s[$i];
            if($c=="\n"){
                $i++;
                $sep=-1;
                $j=$i;
                $l=0;
                $nl++;
                continue;
            }
            if($c==' ') $sep=$i;
            $l+=$cw[$c];
            if($l>$wmax){
                if($sep==-1){
                    if($i==$j) $i++;
                } else $i=$sep+1;
                $sep=-1;
                $j=$i;
                $l=0;
                $nl++;
            } else $i++;
        }
        return $nl;
    }
}

// Initialize PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,"Job Card Accountability Report",0,1,'C');
$pdf->Ln(10);

// Format header dates
$created = !empty($job['created_at']) ? date('y/m/d', strtotime($job['created_at'])) : '-';
$dispatched = !empty($job['dispatched_at']) ? date('y/m/d', strtotime($job['dispatched_at'])) : '-';
$due = !empty($job['due_date']) ? date('y/m/d', strtotime($job['due_date'])) : '-';
$completed = !empty($job['completed_date']) ? date('y/m/d', strtotime($job['completed_date'])) : '-';

// Job Card Info
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,7,"Job Card: ".$job['job_card_number']." | Department: ".$job['department']." | Branch: ".$job['branch'],0,1);

$pdf->SetFont('Arial','',11);
$pdf->MultiCell(0,6,"Customer: ".$job['customer_name']." | Process: ".$job['process_type']);
$pdf->MultiCell(0,6,"Order Desc: ".$job['order_description']);
$pdf->Cell(0,6,"Total Qty: ".$job['total_order_quantity']." | Delivered Qty: ".$job['delivered_quantity'],0,1);
$pdf->Cell(0,6,"Status: ".$job['status']." | Created: $created | Dispatched: $dispatched | Due: $due | Completed: $completed",0,1);
$pdf->Ln(15);

// Fetch stages
$stagesResult = $mysqli->query("SELECT * FROM job_card_stages WHERE job_card_id = $job_card_id ORDER BY id ASC");

if($stagesResult->num_rows > 0){
    // Table header
    $pdf->SetFont('Arial','B',11);
    $header = ['Stage'=>52, 'Status'=>25, 'Assigned To'=>48, 'Started At'=>20, 'Completed At'=>25, 'Duration'=>20];
    foreach($header as $col => $w){
        $pdf->Cell($w,7,$col,1,0,'C');
    }
    $pdf->Ln();
    $pdf->SetFont('Arial','',10);

    while($stage = $stagesResult->fetch_assoc()){
        // Assigned names
        $assignedNames = '';
        if(!empty($stage['assigned_to'])){
            $ids = explode(',',$stage['assigned_to']);
            $names = [];
            foreach($ids as $eid){
                $eid = intval($eid);
                $res = $mysqli->query("SELECT employee_name FROM employees WHERE id=$eid");
                if($res->num_rows>0) $names[] = $res->fetch_assoc()['employee_name'];
            }
            $assignedNames = implode(", ", $names);
        }

        // Format stage dates
        $startedAt = !empty($stage['started_at']) ? date('y/m/d', strtotime($stage['started_at'])) : '-';
        $completedAt = !empty($stage['completed_at']) ? date('y/m/d', strtotime($stage['completed_at'])) : '-';

        // Duration in HH:MM
        $duration = '-';
        if(!empty($stage['started_at']) && !empty($stage['completed_at'])){
            $start = new DateTime($stage['started_at']);
            $end = new DateTime($stage['completed_at']);
            $minutes = round(($end->getTimestamp() - $start->getTimestamp())/60);
            $duration = sprintf('%02d:%02d', floor($minutes/60), $minutes%60);
        }

        // Calculate row height (only based on "Assigned To")
        $lineHeight = 6;
        $nbLines = max(
            $pdf->NbLines($header['Assigned To'], $assignedNames),
            1
        );
        $rowHeight = $lineHeight * $nbLines;

        $x = $pdf->GetX();
        $y = $pdf->GetY();

        // Stage (single line, no wrapping)
        $pdf->Cell($header['Stage'], $rowHeight, $stage['stage_name'], 1);
        $pdf->SetXY($x+$header['Stage'],$y);

        // Status
        $pdf->Cell($header['Status'], $rowHeight, $stage['status'], 1);
        $pdf->SetXY($x+$header['Stage']+$header['Status'],$y);

        // Assigned To (multi-line if needed)
        $pdf->MultiCell($header['Assigned To'], $lineHeight, $assignedNames, 1);
        $pdf->SetXY($x+$header['Stage']+$header['Status']+$header['Assigned To'],$y);

        // Started At
        $pdf->Cell($header['Started At'], $rowHeight, $startedAt, 1);
        $pdf->SetXY($x+$header['Stage']+$header['Status']+$header['Assigned To']+$header['Started At'],$y);

        // Completed At
        $pdf->Cell($header['Completed At'], $rowHeight, $completedAt, 1);
        $pdf->SetXY($x+$header['Stage']+$header['Status']+$header['Assigned To']+$header['Started At']+$header['Completed At'],$y);

        // Duration
        $pdf->Cell($header['Duration'], $rowHeight, $duration, 1);
        $pdf->Ln();
    }
}else{
    $pdf->Cell(0,6,"No stages recorded.",0,1);
}

// Output PDF
$pdf->Output("I","Job_Card_{$job['job_card_number']}_Report.pdf");
?>
