<?php
use fpdf\fpdf\FPDF;
session_start();
require('fpdf/fpdf.php');

$type = $_GET['type'] ?? '';
$month = $_GET['month'] ?? '';

if (!$type || !$month) {
    die("Missing parameters");
}

if (!preg_match('/^\d{4}-\d{2}$/', $month)) {
    die("Invalid month format");
}

$branch = $_SESSION['branch'] ?? null;
if (!$branch) {
    die("User branch not defined.");
}

$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect: " . $mysqli->connect_error);
}

class PDF extends FPDF {
    private $color_red = [222, 26, 28];

    function Header() {
        $pageWidth = $this->GetPageWidth();
        $logoWidth = 60;
        $rightMargin = 10;
        $x = $pageWidth - $logoWidth - $rightMargin;
        $y = 2;
        $this->Image('Images/lgo.png', $x, $y, $logoWidth);

        $this->SetTextColor(48, 48, 125);
        $this->SetFont('Arial', 'B', 16);
        $this->SetY($y + $logoWidth / 2 + 10);
        $this->Cell(0, 10, 'Monthly Report', 0, 1, 'C');
        $this->Ln(5);
        $this->SetTextColor(0, 0, 0);
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        list($r, $g, $b) = $this->color_red;
        $this->SetTextColor($r, $g, $b);
        $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }

    function ReportTitle($type, $month) {
        list($r, $g, $b) = $this->color_red;
        $this->SetTextColor($r, $g, $b);
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 10, "Report Type: " . ucfirst(str_replace("_", " ", $type)), 0, 1);
        $this->Cell(0, 10, "Month: " . date("F Y", strtotime($month)), 0, 1);
        $this->Ln(5);
        $this->SetTextColor(0, 0, 0);
    }

    function TableHeader(array $headers, array $widths) {
        list($r, $g, $b) = $this->color_red;
        $this->SetFillColor($r, $g, $b);
        $this->SetTextColor(255, 255, 255);
        $this->SetFont('Arial', 'B', 10);
        foreach ($headers as $i => $header) {
            $this->Cell($widths[$i], 10, $header, 1, 0, 'C', true);
        }
        $this->Ln();
        $this->SetTextColor(0, 0, 0);
        $this->SetFont('Arial', '', 10);
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->ReportTitle($type, $month);

switch ($type) {
    case 'job_cards':
        $stmt = $mysqli->prepare("SELECT job_card_number, status, department, due_date, completed_date FROM job_cards WHERE DATE_FORMAT(created_at, '%Y-%m') = ? AND branch = ?");
        $stmt->bind_param('ss', $month, $branch);
        $stmt->execute();
        $result = $stmt->get_result();

        $headers = ['Job Card', 'Status', 'Department', 'Due Date', 'Completed Date'];
        $widths = [30, 25, 35, 30, 40];
        $pdf->TableHeader($headers, $widths);

        while ($row = $result->fetch_assoc()) {
            $pdf->Cell(30, 10, $row['job_card_number'], 1);
            $pdf->Cell(25, 10, $row['status'], 1);
            $pdf->Cell(35, 10, $row['department'], 1);
            $pdf->Cell(30, 10, $row['due_date'] ?: 'N/A', 1);
            $pdf->Cell(40, 10, $row['completed_date'] ?: 'N/A', 1);
            $pdf->Ln();
        }
        break;

    case 'overdue':
        $stmt = $mysqli->prepare("SELECT job_card_number, department, due_date, DATEDIFF(CURDATE(), due_date) AS days_overdue FROM job_cards WHERE status = 'open' AND due_date < CURDATE() AND branch = ?");
        $stmt->bind_param('s', $branch);
        $stmt->execute();
        $result = $stmt->get_result();

        $headers = ['Job Card', 'Department', 'Due Date', 'Days Overdue'];
        $widths = [40, 50, 40, 40];
        $pdf->TableHeader($headers, $widths);

        while ($row = $result->fetch_assoc()) {
            $pdf->Cell(40, 10, $row['job_card_number'], 1);
            $pdf->Cell(50, 10, $row['department'], 1);
            $pdf->Cell(40, 10, $row['due_date'], 1);
            $pdf->Cell(40, 10, $row['days_overdue'], 1);
            $pdf->Ln();
        }
        break;

    case 'delivery_performance':
        $stmt = $mysqli->prepare("
            SELECT 
                jc.department,
                COUNT(*) AS total_orders,
                COUNT(dn.job_card_id) AS delivered_orders
            FROM job_cards jc
            LEFT JOIN delivery_notes dn ON jc.id = dn.job_card_id
            WHERE DATE_FORMAT(jc.created_at, '%Y-%m') = ? AND jc.branch = ?
            GROUP BY jc.department
        ");
        $stmt->bind_param('ss', $month, $branch);
        $stmt->execute();
        $result = $stmt->get_result();

        $headers = ['Department', 'Total Orders', 'Delivered', 'Pending', 'Delivery %'];
        $widths = [50, 30, 30, 30, 30];
        $pdf->TableHeader($headers, $widths);

        while ($row = $result->fetch_assoc()) {
            $pending = $row['total_orders'] - $row['delivered_orders'];
            $percent = $row['total_orders'] > 0 ? round(($row['delivered_orders'] / $row['total_orders']) * 100) : 0;
            $pdf->Cell(50, 10, $row['department'], 1);
            $pdf->Cell(30, 10, $row['total_orders'], 1);
            $pdf->Cell(30, 10, $row['delivered_orders'], 1);
            $pdf->Cell(30, 10, $pending, 1);
            $pdf->Cell(30, 10, $percent . '%', 1);
            $pdf->Ln();
        }
        break;

    case 'returned':
        $stmt = $mysqli->prepare("
            SELECT r.original_job_card_number, r.new_job_card_number, j.department, r.reason, r.created_at
            FROM job_card_reissues r
            LEFT JOIN job_cards j ON r.original_job_card_number = j.job_card_number
            WHERE DATE_FORMAT(r.created_at, '%Y-%m') = ? AND j.branch = ?
            ORDER BY r.created_at DESC
        ");
        $stmt->bind_param('ss', $month, $branch);
        $stmt->execute();
        $result = $stmt->get_result();

        $headers = ['Original Job Card', 'New Job Card', 'Department', 'Reason', 'Date'];
        $widths = [40, 40, 40, 50, 30];
        $pdf->TableHeader($headers, $widths);

        while ($row = $result->fetch_assoc()) {
            $pdf->Cell(40, 10, $row['original_job_card_number'], 1);
            $pdf->Cell(40, 10, $row['new_job_card_number'], 1);
            $pdf->Cell(40, 10, $row['department'], 1);
            $pdf->Cell(50, 10, $row['reason'], 1);
            $pdf->Cell(30, 10, $row['created_at'], 1);
            $pdf->Ln();
        }
        break;

    default:
        $pdf->Cell(0, 10, 'Invalid report type selected.', 0, 1);
}

$pdf->Output();
