<?php
use fpdf\fpdf\FPDF;
session_start();
require('fpdf/fpdf.php');
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");

function getNextQuoteNumber($mysqli) {
    $result = $mysqli->query("SELECT quote_number FROM quotes ORDER BY id DESC LIMIT 1");
    if ($row = $result->fetch_assoc()) {
        preg_match('/QU-(\\d+)/', $row['quote_number'], $matches);
        $next = isset($matches[1]) ? intval($matches[1]) + 1 : 10000;
    } else {
        $next = 10000;
    }
    return 'QU-' . $next;
}

class PDF extends FPDF {
    function Header() {
        $this->Image('Images/lgo.png', 12, 4, 50); // Moves the logo 6 units higher
        $this->SetFont('Arial','B',12);
        $this->SetXY(60, 10);
        $this->Cell(0,6,'MASTEKA PRINTING WORX',0,1,'R');
        $this->SetFont('Arial','',9);
        $this->SetX(60);
        $this->MultiCell(0,4,
            "Head Office: Plot 9332 Jwaneng- 5882701\n" .
            "Orapa Branch: Plot 5119 Letlhakane Industrial- 2974670\n" .
            "Cell: 71487741\nTel: +267 5882701 / 797 4670\nFax: +267 588 2987\n" .
            "Email: sales@mastekaprinting.com\nWeb: www.mastekaprinting.com\n" .
            "Company Reg: BW00000452554\nVAT No: BW00000452554-00-05-21", 0, 'R');
        $this->Ln(5);
        $this->Ln(5);
    }

    function QuoteHeader($quote_number, $quote_date, $customer_name, $company, $address) {
        $this->SetY(45);
        $this->SetFont('Arial','B',16);
        $this->Cell(0,6,"Quote #: $quote_number",0,1,'L');
        $this->Cell(0,6,"Date: $quote_date",0,1,'L');
        $this->Ln(4);

        // Labels
        $this->SetFont('Arial','B',10);
        $this->Cell(95,6,"Customer:",'B',0);
        $this->SetX(140);
        $this->Cell(60,6,"Shipping Address:",'B',1);

        // Values
        $this->SetFont('Arial','',10);
        $this->Cell(95,6,"$customer_name",0,0);
        $this->SetX(140);
        $this->Cell(60,6,"$customer_name",0,1);

        $this->Cell(95,6,"$company",0,0);
        $this->SetX(140);
        $this->Cell(60,6,"$company",0,1);

        $this->Cell(95,6,"$address",0,0);
        $this->SetX(140);
        $this->Cell(60,6,"$address",0,1);

        $this->Ln(5);
    }
    function generate_pdf($quote, $customer, $items) {
        $pdf = new PDF();
        $pdf->AddPage();
        $pdf->QuoteHeader(
            $quote['quote_number'],
            date('Y-m-d', strtotime($quote['quote_date'])),
            $customer['name'],
            $customer['company_name'],
            $quote['shipping_address']
        );
        $pdf->QuoteTableHeader();

        while ($item = $items->fetch_assoc()) {
            $net = $item['quantity'] * $item['unit_price'];
            $pdf->QuoteTableRow(
                $item['description'],
                $item['quantity'],
                $item['unit_price'],
                $item['vat_percent'],
                $net
            );
        }

        $pdf->Totals($quote['subtotal'], $quote['vat'], $quote['total']);
        $pdf->Output('I', $quote['quote_number'] . '.pdf');
    }


    function QuoteTableHeader() {
        $this->SetFont('Arial','B',10);
        $this->Cell(80,7,'Description',1);
        $this->Cell(20,7,'Qty',1);
        $this->Cell(30,7,'Unit Price',1);
        $this->Cell(20,7,'VAT %',1);
        $this->Cell(40,7,'Net Amount',1);
        $this->Ln();
    }

    function QuoteTableRow($desc, $qty, $price, $vat, $net) {
        $this->SetFont('Arial','',10);

        // Save current position
        $x = $this->GetX();
        $y = $this->GetY();

        // Print description cell (MultiCell)
        $this->MultiCell(80, 6, $desc, 1);

        // Calculate height of MultiCell by difference in y position
        $height = $this->GetY() - $y;

        // Move back to the right of description cell, at original y
        $this->SetXY($x + 80, $y);

        // Print other cells with the same height
        $this->Cell(20, $height, $qty, 1, 0, 'C');
        $this->Cell(30, $height, number_format($price, 2), 1, 0, 'R');
        $this->Cell(20, $height, $vat, 1, 0, 'C');
        $this->Cell(40, $height, number_format($net, 2), 1, 1, 'R');
    }


    function Totals($subtotal, $vat, $total) {
        $this->Ln(2); // Slight space before totals
        $this->SetFont('Arial','B',10);

        // Subtotal
        $this->Cell(150,4,'Sub Total: (exc. VAT)',0,0,'R');
        $this->Cell(40,4,number_format($subtotal,2),0,1,'R');

        // VAT
        $this->Cell(150,4,'VAT:',0,0,'R');
        $this->Cell(40,4,number_format($vat,2),0,1,'R');

        // Underline before Total
        $lineY = $this->GetY();
        $this->SetDrawColor(0, 0, 0);
        $this->Line(120, $lineY, 200, $lineY);

        // Total
        $this->Cell(150,4,'Total (inc. VAT):',0,0,'R');
        $this->Cell(40,4,number_format($total,2),0,1,'R');
    }

    function Footer() {
        $this->SetY(-75);

        // Terms
        $this->SetFont('Arial', 'B', 9);
        $this->Write(5, 'Terms: ');
        $this->SetFont('Arial', '', 8);
        $this->Write(5, 'This quote is guaranteed for 30 days, after this all prices may be subject to change.');
        $this->Ln(6);

        // Additional Terms about goods and returns
        $this->SetFont('Arial', 'B', 6);
        $this->Write(5, 'ALL GOODS REMAIN THE PROPERTY OF MASTEKA PRINTING UNTIL FULLY PAID FOR.');
        $this->Ln(5);
        $this->Write(5, '10% HANDLING CHARGE FOR ALL RETURNS.');
        $this->Ln(5);
        $this->Write(5, 'RETURNS ACCEPTED WITHIN 5 DAYS IN ORIGINAL STATE AND PACKAGING WITH ORIGINAL INVOICE / RECEIPT.');
        $this->Ln(6);

        // Banking Details
        $this->SetFont('Arial', 'B', 9);
        $this->Cell(0, 5, 'Banking Details:', 0, 1, 'L');

        $this->SetFont('Arial', 'B', 8);
        $this->Cell(0, 4, 'Account Name: Masteka Pty Ltd*', 0, 1, 'L');

        $this->SetFont('Arial', '', 8);
        $this->Write(4, 'FNB Botswana, Jwaneng Branch Code 283067, ');
        $this->SetFont('Arial', 'B', 8);
        $this->Write(4, 'Account #: 62299833444');
        $this->Ln(4);

        $this->SetFont('Arial', '', 8);
        $this->Write(4, 'Standard Chartered Bank, Game City Branch, ');
        $this->SetFont('Arial', 'B', 8);
        $this->Write(4, 'Account #: 0100106625500');
        $this->Ln(4);

        $this->SetFont('Arial', '', 8);
        $this->Write(4, 'Stanbic Bank, Gaborone Industrial Branch, ');
        $this->SetFont('Arial', 'B', 8);
        $this->Write(4, 'Account #: 9060003916516');
        $this->Ln(6);

        // Call Centers
        $this->SetFont('Arial', 'B', 9);
        $this->Write(5, 'Call Centers: ');
        $this->SetFont('Arial', '', 8);
        $this->Write(5, 'Jwaneng - 77108161     Letlhakane: 71237975');
    }

}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $company = $_POST['company_name'];
    $address = $_POST['address'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];

    $stmt = $mysqli->prepare("SELECT id FROM customers WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->bind_result($customer_id);
        $stmt->fetch();
    } else {
        $stmt = $mysqli->prepare("INSERT INTO customers (name, company_name, address, phone, email, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
        $stmt->bind_param("sssss", $name, $company, $address, $phone, $email);
        $stmt->execute();
        $customer_id = $stmt->insert_id;
    }

    $quote_number = getNextQuoteNumber($mysqli);
    $quote_date = date('Y-m-d');
    $shipping_address = $address;
    $subtotal = 0;
    $vat_total = 0;
    $total = 0;

    $stmt = $mysqli->prepare("INSERT INTO quotes (quote_number, customer_id, shipping_address, quote_date, subtotal, vat, total, created_at) VALUES (?, ?, ?, ?, 0, 0, 0, NOW())");
    $stmt->bind_param("siss", $quote_number, $customer_id, $shipping_address, $quote_date);
    $stmt->execute();
    $quote_id = $stmt->insert_id;

    foreach ($_POST['description'] as $i => $desc) {
        $qty = $_POST['quantity'][$i];
        $price = $_POST['unit_price'][$i];
        $vat = $_POST['vat_percent'][$i];

        $net = $qty * $price;
        $vat_amount = $net * ($vat / 100);
        $line_total = $net + $vat_amount;

        $subtotal += $net;
        $vat_total += $vat_amount;
        $total += $line_total;

        $stmt = $mysqli->prepare("INSERT INTO quote_items (quote_id, description, quantity, unit_price, vat_percent) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("isidd", $quote_id, $desc, $qty, $price, $vat);
        $stmt->execute();
    }

    $stmt = $mysqli->prepare("UPDATE quotes SET subtotal = ?, vat = ?, total = ? WHERE id = ?");
    $stmt->bind_param("dddi", $subtotal, $vat_total, $total, $quote_id);
    $stmt->execute();

    $pdf = new PDF();
    $pdf->AddPage();
    $pdf->QuoteHeader($quote_number, $quote_date, $name, $company, $address);
    $pdf->QuoteTableHeader();

    foreach ($_POST['description'] as $i => $desc) {
        $qty = $_POST['quantity'][$i];
        $price = $_POST['unit_price'][$i];
        $vat = $_POST['vat_percent'][$i];
        $net = $qty * $price;
        $pdf->QuoteTableRow($desc, $qty, $price, $vat, $net);
    }

    $pdf->Totals($subtotal, $vat_total, $total);
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="' . $quote_number . '.pdf"');
    header('Cache-Control: private, max-age=0, must-revalidate');
    header('Pragma: public');

    $pdf->Output('I', "$quote_number.pdf");
}

?>
