<?php
session_start();
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Connection failed: " . $mysqli->connect_error);
}

$error = '';
$success = '';
$id = intval($_GET['id'] ?? 0);
if (!$id) {
    die("Missing user ID.");
}

// Fetch user and employee data
$stmt = $mysqli->prepare("
    SELECT u.username, u.role, u.branch,
           e.employee_name, e.department, e.branch AS emp_branch, e.position, e.is_supervisor, e.status, e.email, e.phone
    FROM users u
    LEFT JOIN employees e ON u.id = e.user_id
    WHERE u.id = ?
");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
$stmt->close();

if (!$data) {
    die("User not found.");
}

$roles = ['Commercial Branding', 'Sales', 'Signage', 'Bulk Printing'];
$departments = ['Commercial Branding', 'Sales', 'Signage', 'Bulk Printing'];
$branches = ['Jwaneng', 'Letlhakane'];
$statuses = ['Active', 'Inactive'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $role = $_POST['role'] ?? '';
    $branch = $_POST['branch'] ?? '';
    $employee_name = trim($_POST['employee_name']);
    $department = $_POST['department'] ?? '';
    $status = $_POST['status'] ?? '';
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $position = 'Supervisor';
    $is_supervisor = 1;

    if (!$role || !$branch || !$employee_name || !$department || !$status) {
        $error = "Please fill all required fields.";
    } elseif (
        !in_array($role, $roles) ||
        !in_array($branch, $branches) ||
        !in_array($department, $departments) ||
        !in_array($status, $statuses)
    ) {
        $error = "Invalid input in dropdown.";
    } else {
        // Update `users`
        $stmt = $mysqli->prepare("UPDATE users SET role = ?, branch = ? WHERE id = ?");
        $stmt->bind_param("ssi", $role, $branch, $id);
        $stmt->execute();
        $stmt->close();

        // Update `employees` via user_id
        $stmt = $mysqli->prepare("
            UPDATE employees 
            SET employee_name = ?, department = ?, branch = ?, position = ?, is_supervisor = ?, status = ?, email = ?, phone = ?
            WHERE user_id = ?
        ");
        $stmt->bind_param("ssssisssi", $employee_name, $department, $branch, $position, $is_supervisor, $status, $email, $phone, $id);
        $stmt->execute();
        $stmt->close();

        $success = "Supervisor updated successfully.";

        // Reload updated data
        $stmt = $mysqli->prepare("
            SELECT u.username, u.role, u.branch,
                   e.employee_name, e.department, e.branch AS emp_branch, e.position, e.is_supervisor, e.status, e.email, e.phone
            FROM users u
            LEFT JOIN employees e ON u.id = e.user_id
            WHERE u.id = ?
        ");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = $result->fetch_assoc();
        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Supervisor</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: auto; padding: 20px; background: #f4f4f4; }
        form { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        label { display: block; margin-top: 10px; font-weight: bold; }
        input, select { width: 100%; padding: 8px; margin-top: 5px; }
        button { margin-top: 20px; padding: 10px 20px; background: #30307d; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .error, .success { margin-bottom: 15px; padding: 10px; border-radius: 5px; }
        .error { background: #fdd; border: 1px solid #f99; }
        .success { background: #dfd; border: 1px solid #9f9; }
    </style>
</head>
<body>

<h2>Edit Supervisor</h2>

<?php if ($error): ?><div class="error"><?= htmlspecialchars($error) ?></div><?php endif; ?>
<?php if ($success): ?><div class="success"><?= htmlspecialchars($success) ?></div><?php endif; ?>

<form method="POST">
    <label>Username:</label>
    <input type="text" value="<?= htmlspecialchars($data['username']) ?>" disabled>

    <label>Role (Department Lead):</label>
    <select name="role" required>
        <option value="">-- Select Role --</option>
        <?php foreach ($roles as $r): ?>
            <option value="<?= $r ?>" <?= ($data['role'] === $r) ? 'selected' : '' ?>><?= $r ?></option>
        <?php endforeach; ?>
    </select>

    <label>Branch:</label>
    <select name="branch" required>
        <option value="">-- Select Branch --</option>
        <?php foreach ($branches as $b): ?>
            <option value="<?= $b ?>" <?= ($data['branch'] === $b) ? 'selected' : '' ?>><?= $b ?></option>
        <?php endforeach; ?>
    </select>

    <label>Employee Name:</label>
    <input type="text" name="employee_name" required value="<?= htmlspecialchars($data['employee_name']) ?>">

    <label>Department:</label>
    <select name="department" required>
        <option value="">-- Select Department --</option>
        <?php foreach ($departments as $d): ?>
            <option value="<?= $d ?>" <?= ($data['department'] === $d) ? 'selected' : '' ?>><?= $d ?></option>
        <?php endforeach; ?>
    </select>

    <label>Position:</label>
    <input type="text" value="Supervisor" disabled>

    <label>Status:</label>
    <select name="status" required>
        <?php foreach ($statuses as $st): ?>
            <option value="<?= $st ?>" <?= ($data['status'] === $st) ? 'selected' : '' ?>><?= $st ?></option>
        <?php endforeach; ?>
    </select>

    <label>Email:</label>
    <input type="email" name="email" value="<?= htmlspecialchars($data['email']) ?>">

    <label>Phone:</label>
    <input type="text" name="phone" value="<?= htmlspecialchars($data['phone']) ?>">

    <button type="submit">Update Supervisor</button>
</form>

<p><a href="users.php">← Back to Supervisors</a></p>

</body>
</html>
