<?php
session_start();
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) die("Connection failed: " . $mysqli->connect_error);

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$id) die("Invalid staff ID.");

// Fetch employee
$stmt = $mysqli->prepare("SELECT * FROM employees WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$employee = $result->fetch_assoc();
$stmt->close();

if (!$employee) die("Staff not found.");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $employee_name = trim($_POST['employee_name']);
    $department = $_POST['department'];
    $branch = $_POST['branch'];
    $status = $_POST['status'];
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $position = 'Staff'; // fixed
    $is_supervisor = 0; // enforced

    $stmt = $mysqli->prepare("UPDATE employees SET employee_name=?, department=?, branch=?, position=?, is_supervisor=?, status=?, email=?, phone=? WHERE id=?");
    $stmt->bind_param("ssssisssi", $employee_name, $department, $branch, $position, $is_supervisor, $status, $email, $phone, $id);
    $stmt->execute();
    $stmt->close();

    header("Location: staff.php");
    exit;
}

$departments = ['Commercial Branding', 'Sales', 'Signage', 'Bulk Printing'];
$branches = ['Jwaneng', 'Letlhakane'];
$statuses = ['Active', 'Inactive'];
?>

<!DOCTYPE html>
<html>
<head><title>Edit Staff</title></head>
<body>
<h2>Edit Staff Member</h2>

<form method="POST">
    <label>Employee Name:<br>
        <input type="text" name="employee_name" required value="<?= htmlspecialchars($employee['employee_name']) ?>">
    </label><br><br>

    <label>Department:<br>
        <select name="department" required>
            <option value="">-- Select Department --</option>
            <?php foreach ($departments as $dept): ?>
                <option value="<?= $dept ?>" <?= ($employee['department'] === $dept) ? 'selected' : '' ?>><?= $dept ?></option>
            <?php endforeach; ?>
        </select>
    </label><br><br>

    <label>Branch:<br>
        <select name="branch" required>
            <?php foreach ($branches as $br): ?>
                <option value="<?= $br ?>" <?= ($employee['branch'] === $br) ? 'selected' : '' ?>><?= $br ?></option>
            <?php endforeach; ?>
        </select>
    </label><br><br>

    <label>Position:<br>
        <input type="text" value="Staff" disabled>
        <input type="hidden" name="position" value="Staff">
    </label><br><br>

    <label>Status:<br>
        <select name="status" required>
            <?php foreach ($statuses as $stat): ?>
                <option value="<?= $stat ?>" <?= ($employee['status'] === $stat) ? 'selected' : '' ?>><?= $stat ?></option>
            <?php endforeach; ?>
        </select>
    </label><br><br>

    <label>Email:<br>
        <input type="email" name="email" value="<?= htmlspecialchars($employee['email']) ?>">
    </label><br><br>

    <label>Phone:<br>
        <input type="text" name="phone" value="<?= htmlspecialchars($employee['phone']) ?>">
    </label><br><br>

    <button type="submit">Update</button>
</form>

<p><a href="staff.php">← Back to Staff</a></p>
</body>
</html>
