<?php
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect: " . $mysqli->connect_error);
}

$id = intval($_GET['id'] ?? 0);
if (!$id) {
    die("Invalid job card ID.");
}

$message = "";

$stmt = $mysqli->prepare("SELECT status, due_date, completed_date FROM job_cards WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($status, $due_date, $completed_date);
if (!$stmt->fetch()) {
    die("Job card not found.");
}
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_status = $_POST['status'] ?? $status;
    $new_due_date = $_POST['due_date'] ?: null;
    $new_completed_date = $_POST['completed_date'] ?: null;

    $update_stmt = $mysqli->prepare("UPDATE job_cards SET status = ?, due_date = ?, completed_date = ? WHERE id = ?");
    $update_stmt->bind_param("sssi", $new_status, $new_due_date, $new_completed_date, $id);
    $update_stmt->execute();

    $message = $update_stmt->affected_rows > 0 ? "Job card updated successfully." : "No changes made or update failed.";

    $update_stmt->close();

    // Update local variables for form display
    $status = $new_status;
    $due_date = $new_due_date;
    $completed_date = $new_completed_date;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Edit Job Card #<?= $id ?></title>
    <style>
        body { font-family: Arial,sans-serif; padding: 20px; background: #eef6fc; }
        form { background: white; padding: 20px; max-width: 400px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        label { display: block; margin-top: 10px; }
        select, input { padding: 8px; width: 100%; margin-top: 5px; }
        button { margin-top: 15px; background: #30307d; color: white; border: none; padding: 10px; border-radius: 5px; cursor: pointer; }
        .message { margin-top: 15px; padding: 10px; background: #d4edda; border: 1px solid #c3e6cb; color: #155724; border-radius: 5px; }
        a { display: inline-block; margin-top: 15px; color: #f36e25; text-decoration: none; }
        nav a { margin-right: 15px; }
    </style>
</head>
<body>

<nav>
    <a href="job_cards_list.php">Job Cards</a>
</nav>

<h1>Edit Job Card #<?= $id ?></h1>

<form method="POST">
    <label>Status
        <select name="status" required>
            <option value="open" <?= $status === 'open' ? 'selected' : '' ?>>Open</option>
            <option value="closed" <?= $status === 'closed' ? 'selected' : '' ?>>Closed</option>
        </select>
    </label>

    <label>Due Date
        <input type="date" name="due_date" value="<?= htmlspecialchars($due_date) ?>" />
    </label>

    <label>Completed Date
        <input type="date" name="completed_date" value="<?= htmlspecialchars($completed_date) ?>" />
    </label>

    <button type="submit">Save Changes</button>
</form>

<?php if ($message): ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<a href="job_cards_list.php">← Back to Job Cards List</a>

</body>
</html>
