<?php
session_start();
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['job_card_id'])) {
    die("Invalid request.");
}

$job_card_id = (int)$_POST['job_card_id'];

// Check if all stages completed
$stmt = $conn->prepare("SELECT COUNT(*) AS incomplete_count FROM job_card_stages WHERE job_card_id = ? AND LOWER(status) != 'completed'");
$stmt->bind_param("i", $job_card_id);
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();
$stmt->close();

if ($res['incomplete_count'] > 0) {
    die("Cannot dispatch. Some stages are not completed.");
}

// Mark dispatched
$upd = $conn->prepare("UPDATE job_cards SET dispatched = 1, dispatched_at = NOW() WHERE id = ?");
$upd->bind_param("i", $job_card_id);
$upd->execute();
$upd->close();

// Redirect back
header("Location: job_card_view.php?id=$job_card_id");
exit;
