<?php
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect: " . $mysqli->connect_error);
}

$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $orders = max(0, intval($_POST['orders']));
    $delivered = max(0, intval($_POST['delivered']));
    $pending = max(0, $orders - $delivered); // Avoid negatives
    $selectedStatus = $_POST['status'];

    // Smart status control
    if ($pending === 0) {
        $status = 'closed';
    } else {
        // If pending > 0, don't allow closed to be saved again
        $status = ($selectedStatus === 'closed') ? 'open' : $selectedStatus;
    }

    $stmt = $mysqli->prepare("UPDATE  SET orders = ?, delivered = ?, pending = ?, status = ? WHERE id = ?");
    $stmt->bind_param("iiisi", $orders, $delivered, $pending, $status, $id);
    $stmt->execute();

    $message = $stmt->affected_rows > 0 ? "Delivery update saved." : "No changes or error.";
    $stmt->close();
}


// Fetch all delivery updates from deliveries table
$result = $mysqli->query("SELECT * FROM deliveries ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Delivery Updates</title>
    <style>
        body { font-family: Arial,sans-serif; padding: 20px; background: #eef6fc; }
        table { border-collapse: collapse; width: 100%; background: white; }
        th, td { border: 1px solid #ccc; padding: 10px; text-align: center; }
        th { background: #30307d; color: white; }
        input, select { width: 80px; padding: 5px; }
        button { background: #30307d; color: white; border: none; padding: 5px 10px; border-radius: 5px; cursor: pointer; }
        .message { margin-bottom: 15px; padding: 10px; background: #d4edda; border: 1px solid #c3e6cb; color: #155724; border-radius: 5px; }
        nav a { margin-right: 15px; }
        button{
            background: #30307d;
            color: white;
            border: none;
            padding: 8px 14px;
            border-radius: 6px;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        button:hover {
            background: #1f1f5c;
        }
        nav {
            margin-bottom: 20px;
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        nav a {
            display: inline-block;
            background-color: #30307d;
            color: white;
            text-decoration: none;
            padding: 10px 16px;
            border-radius: 6px;
            font-weight: bold;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }

        nav a:hover {
            background-color: #1f1f5c;
            transform: translateY(-2px);
        }

    </style>
</head>
<body>

<h1>Delivery Updates</h1>
<nav>
    <a href="index.php">Production</a>
    <a href="Insert.php">DashBoard</a>
    <a href="job_cards_list.php">Job Cards</a>
    <a href="delivery_updates_list.php">Delivery Updates</a>
    <a href="team_hours_list.php">Team Hours</a>
</nav>




<?php if ($message): ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<table>
    <thead>
    <tr>
        <th>Department</th><th>Orders</th><th>Delivered</th><th>Pending</th><th>Status</th><th>Save</th>
    </tr>
    </thead>
    <tbody>
    <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <form method="POST">
                <td><?= htmlspecialchars($row['department']) ?></td>
                <td><input type="number" name="orders" value="<?= $row['orders'] ?>" min="0" required></td>
                <td><input type="number" name="delivered" value="<?= $row['delivered'] ?>" min="0" required></td>
                <td><?= $row['pending'] ?></td> <!-- show calculated pending -->
                <td>
                    <select name="status" required>
                        <option value="open" <?= $row['status'] == 'open' ? 'selected' : '' ?>>Open</option>
                        <option value="closed" <?= $row['status'] == 'closed' ? 'selected' : '' ?>>Closed</option>
                        <option value="pending" <?= $row['status'] == 'pending' ? 'selected' : '' ?>>Pending</option>
                    </select>
                </td>
                <td>
                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                    <button type="submit">Save</button>
                </td>
            </form>
        </tr>
    <?php endwhile; ?>
    </tbody>
</table>

</body>
</html>
