<?php
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect to MySQL: " . $mysqli->connect_error);
}
$result = $mysqli->query("SELECT * FROM customers");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Customers</title>
    <link rel="stylesheet" href="style.css" />

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #eef6fc;
            margin: 0;
            padding: 0;
        }
        nav {
            padding: 12px 30px;
            display: flex;
            gap: 20px;
            align-items: center;
            /* no background color */
            /* no box-shadow */
        }

        nav a {
            color: white;
            text-decoration: none;
            font-weight: 600;
            padding: 8px 15px;
            border-radius: 4px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        nav a:hover {
            background-color: #1f1f5c;
            color: white;
        }

        .container {
            max-width: 900px;
            margin: 30px auto;
            background-color: white;
            padding: 25px 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        h2 {
            color: #30307d;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        thead tr {
            background-color: #30307d;
            color: white;
        }

        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }

        tbody tr:hover {
            background-color: #f2f2f2;
        }

        tr.clickable-row {
            cursor: pointer;
        }

        tr.clickable-row a {
            color: inherit;
            text-decoration: none;
        }

        tr.clickable-row:hover {
            background-color: #de1a1c;
            color: white;
        }
    </style>
</head>
<body>
<nav>
    <a href="index.php"> Dashboard</a>
    <a href="customers.php">Customers</a>
    <a href="create_quote.php">Create New Quote</a>

</nav>

<div class="container">

    <h2><i class="fas fa-users"></i> Customers</h2>

    <table>
        <thead>
        <tr>
            <th>Name</th>
            <th>Company</th>
            <th>Email</th>
            <th>Phone</th>
        </tr>
        </thead>
        <tbody>
        <?php while($row = $result->fetch_assoc()): ?>
            <tr class="clickable-row" data-href="customer_details.php?customer_id=<?= $row['id'] ?>">
                <td><a href="customer_details.php?customer_id=<?= $row['id'] ?>"><?= htmlspecialchars($row['name']) ?></a></td>
                <td><?= htmlspecialchars($row['company_name']) ?></td>
                <td><?= htmlspecialchars($row['email']) ?></td>
                <td><?= htmlspecialchars($row['phone']) ?></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>

</div>

<script>
    // Make entire row clickable except for links inside it
    document.querySelectorAll('tr.clickable-row').forEach(row => {
        row.addEventListener('click', e => {
            if(e.target.tagName.toLowerCase() !== 'a') {
                window.location = row.dataset.href;
            }
        });
    });
</script>

</body>
</html>
