<?php
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect to MySQL: " . $mysqli->connect_error);
}

$customer_id = $_GET['customer_id'] ?? 0;
if (!$customer_id) {
    die("Customer ID not provided.");
}

// Fetch customer info
$sql = "SELECT * FROM customers WHERE id = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("i", $customer_id);
$stmt->execute();
$customer = $stmt->get_result()->fetch_assoc();
if (!$customer) {
    die("Customer not found.");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Customer Details - <?= htmlspecialchars($customer['name']) ?></title>
    <link rel="stylesheet" href="style.css" />
    <link
            href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
            rel="stylesheet"
    />
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #eef6fc;
            margin: 0;
            padding: 0;
        }
        nav {
            padding: 12px 30px;
            display: flex;
            gap: 20px;
            align-items: center;
            /* no background color */
            /* no box-shadow */
        }

        nav a {
            color: white;
            text-decoration: none;
            font-weight: 600;
            padding: 8px 15px;
            border-radius: 4px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        nav a:hover {
            background-color: #1f1f5c;
            color: white;
        }

        .container {
            max-width: 900px;
            margin: 30px auto;
            background-color: white;
            padding: 25px 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        tr.clickable-row {
            cursor: pointer;
        }

        tr.clickable-row a {
            color: inherit;
            text-decoration: none;
        }
        tr.clickable-row:hover {
            background-color: #de1a1c;
            color: #eef6fc;
        }

        /* Spacing and color for icons */
        p i, h1 i {
            margin-right: 8px;
            color: #de1a1c;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        thead tr {
            background-color: #30307d;
            color: white;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }
        tbody tr:hover {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>


<nav>
    <a href="index.php"> Dashboard</a>
    <a href="customers.php">Customers</a>
    <a href="create_quote.php">Create New Quote</a>

</nav>

<div class="container">

    <h1><i class="fas fa-user"></i> <?= htmlspecialchars($customer['name']) ?></h1>

    <p><i class="fas fa-building"></i> <?= htmlspecialchars($customer['company_name'] ?? 'N/A') ?></p>
    <p><i class="fas fa-envelope"></i>  <?= htmlspecialchars($customer['email'] ?? 'N/A') ?></p>
    <p><i class="fas fa-phone"></i>  <?= htmlspecialchars($customer['phone'] ?? 'N/A') ?></p>
    <p><i class="fas fa-map-marker-alt"></i>  <?= htmlspecialchars($customer['address'] ?? 'N/A') ?></p>

    <h2>Quotes</h2>

    <?php
    $sql = "SELECT * FROM quotes WHERE customer_id = ? ORDER BY quote_date DESC";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("i", $customer_id);
    $stmt->execute();
    $quotes = $stmt->get_result();

    $status_options = [
        'created' => 'Created',
        'waiting' => 'Waiting for Outsourced Prices',
        'with_client' => 'With Client',
        'not_taken_up' => 'Not Taken Up',
        'successful' => 'Successful'
    ];

    if ($quotes->num_rows === 0) {
        echo "<p>No quotes found.</p>";
    } else {
        echo "<table>";
        echo "<thead><tr><th>Date</th><th>Quote #</th><th>Description</th><th>Status</th></tr></thead>";
        echo "<tbody>";
        while ($quote = $quotes->fetch_assoc()) {
            $quote_link = "quote_detail.php?quote_id=" . urlencode($quote['id']);

            $quote_id = $quote['id'];
            $item_sql = "SELECT description FROM quote_items WHERE quote_id = ?";
            $item_stmt = $mysqli->prepare($item_sql);
            $item_stmt->bind_param("i", $quote_id);
            $item_stmt->execute();
            $item_result = $item_stmt->get_result();

            $descriptions = [];
            while ($item = $item_result->fetch_assoc()) {
                $descriptions[] = $item['description'];
            }
            $item_stmt->close();

            echo "<tr class='clickable-row' data-href='" . htmlspecialchars($quote_link, ENT_QUOTES) . "'>";
            echo "<td>" . htmlspecialchars($quote['quote_date']) . "</td>";
            echo "<td>" . htmlspecialchars($quote['quote_number']) . "</td>";
            echo "<td>" . htmlspecialchars(implode(", ", $descriptions)) . "</td>";
            echo "<td>" . htmlspecialchars($status_options[$quote['status']] ?? $quote['status']) . "</td>";
            echo "</tr>";
        }
        echo "</tbody>";
        echo "</table>";
    }
    $stmt->close();
    ?>

</div>

<script>
    // Make table rows clickable (except on links)
    document.querySelectorAll('tr.clickable-row').forEach(row => {
        row.addEventListener('click', (e) => {
            if (e.target.tagName.toLowerCase() !== 'a') {
                window.location.href = row.getAttribute('data-href');
            }
        });
    });
</script>

</body>
</html>
