<!DOCTYPE html>
<html>
<head>
    <title>Create New Quote</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #eef6fc;
            margin: 0;
            padding: 0;
        }
        nav {
            padding: 12px 30px;
            display: flex;
            gap: 20px;
            align-items: center;
            /* no background color */
            /* no box-shadow */
        }

        nav a {
            color: white;
            text-decoration: none;
            font-weight: 600;
            padding: 8px 15px;
            border-radius: 4px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        nav a:hover {
            background-color: #1f1f5c;
            color: white;
        }


        h2, h3 {
            color: #30307d;
        }

        form {
            max-width: 950px;
            margin: auto;
            padding: 25px;
            border-radius: 6px;
            background: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        label {
            display: block;
            margin: 8px 0 4px;
            color: #333;
        }

        input[type="text"],
        input[type="email"],
        input[type="number"],
        input[list] {
            padding: 8px;
            width: 100%;
            max-width: 300px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
        }

        .form-row {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
        }

        .form-row label {
            flex: 1;
            min-width: 220px;
        }

        .quote-header, .quote-row {
            display: grid;
            grid-template-columns: 3fr 1fr 1fr 1fr auto;
            gap: 10px;
            align-items: center;
            padding: 6px 0;
        }

        .quote-header {
            font-weight: bold;
            background: #f0f0f0;
            padding: 10px;
            border-radius: 4px;
        }

        .quote-row input {
            padding: 6px;
            width: 100%;
            font-size: 13px;
        }

        .item-container {
            margin-bottom: 10px;
        }
        .quote-row {
            display: grid;
            grid-template-columns: 3fr 1fr 1fr 1fr auto;
            gap: 10px;
            align-items: center;
        }

        .quote-row input {
            width: 100%;
            box-sizing: border-box;
        }

        .remove-btn {
            background: #de1a1c;
            color: white;
            border: none;
            padding: 6px 10px;
            font-size: 13px;
            border-radius: 4px;
            cursor: pointer;
        }

        .remove-btn:hover {
            background: #c41a1a;
        }

        .add-btn,
        input[type="submit"] {
            background-color: #30307d;
            color: white;
            padding: 8px 16px;
            border: none;
            font-size: 14px;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 15px;
        }

        .add-btn:hover,
        input[type="submit"]:hover {
            background-color: #2a2a70;
        }

        /* ==== New styles for removing box from customer info inputs ==== */
        /*form > .form-row input[type="text"],
        form > .form-row input[type="email"] {
            border: none;
            background: transparent;
            box-shadow: none;
            padding-left: 0;
            font-size: 15px;
            color: #30307d;
            border-radius: 0;
            width: auto;
            max-width: none;
        }*/

        form > .form-row input[type="text"]:focus,
        form > .form-row input[type="email"]:focus {
            outline: none;
            border-bottom: 2px solid #30307d;
        }

        /* Style the label and input for item count selector */
        #itemCount {
            width: 60px;
            padding: 6px;
            font-size: 14px;
            border-radius: 4px;
            border: 1px solid #ccc;
            margin-right: 10px;
        }

        /* Container for the add multiple items control */
        .add-multiple-container {
            display: flex;
            align-items: center;
            margin-top: 15px;
            max-width: 950px;
            margin-left: auto;
            margin-right: auto;
        }
    </style>
</head>
<body>


<nav>
    <a href="index.php"> Dashboard</a>
    <a href="customers.php">Customers</a>
    <a href="create_quote.php">Create New Quote</a>

</nav>


<form action="generate_quote.php" method="post">
    <h3>Customer Info</h3>
    <div class="form-row">
        <label>Name: <input type="text" name="name" required></label>
        <label>Company: <input type="text" name="company_name"></label>
    </div>
    <div class="form-row">
        <label>Address: <input type="text" name="address"></label>
        <label>Phone: <input type="text" name="phone"></label>
    </div>
    <div class="form-row">
        <label>Email: <input type="email" name="email" required></label>
    </div>

    <h3>Quote Items</h3>

    <div class="quote-header">
        <span>Description</span>
        <span>Qty</span>
        <span>Unit Price</span>
        <span>VAT %</span>
        <span></span>
    </div>
    <div id="items">
        <div class="quote-row item-container">
            <input list="descriptions" name="description[]" required>
            <input type="number" name="quantity[]" min="1" required>
            <input type="number" name="unit_price[]" step="0.01" min="0" required>
            <input type="number" name="vat_percent[]" step="0.01" value="14" required>
            <button type="button" class="remove-btn" onclick="removeItem(this)">Remove</button>
        </div>
    </div>

    <div class="add-multiple-container">
        <label for="itemCount">Add items:</label>
        <input type="number" id="itemCount" min="1" max="20" value="1" />
        <button type="button" class="add-btn" onclick="addItems()">+ Add Items</button>
    </div>

    <input type="submit" name="generate" value="Generate Quote">
</form>

<datalist id="descriptions">
    <option value="Double sided, full colour">
    <option value="PVC">
    <option value="Billboard Branding, full color printed on PVC stretched with tension strip 10.5x2m">
    <option value="Pull Up Banner 2000x850mm, full color printed Digital Print Include Carry Bag">
    <option value="Category C, B, 270x250mm">
    <option value="Artwork Digitalizing, Setup only">
    <option value="Logo Embroidery, Customized Color on various materials">
    <option value="Name, Mono Color print on various materials">
    <option value="Standard mine Size per Fleet Number">
    <option value="A4 Folded into A5, Program with 1 color print and 49 Black and white print outs.">
    <option value="Full Installation at Jwaneng Mine">
    <option value="A3 Document">
    <option value="A4 Document">
    <option value="Lamination A4">
    <option value="Domed, name Tags, 50x30mm">
    <option value="Row mark, name Tags, 50x30mm, with magnetic">
    <option value="Monocolour printed, Duplicate, 2 parts, CB White & CF Blue, Manilla Cover and Chipboard, Saddle stitched">
    <option value="Monocolour printed, Duplicate, CB White & CF Blue, Manilla Cover and Chipboard, Saddle stitched">
    <option value="Monocolour printed, Triplicate, CB White, CFB Yellow & CF Blue, Manilla Cover and Chipboard, Saddle stitched">
    <option value="Number Plate on Clear Acrylic, Cutout Black letters/Numbers">
    <option value="A0 Photo 841x1189mm">
    <option value="A1 Photo, 594x841mm">
    <option value="A2 Photo,420x594mm">
    <option value="A3 Photo, 297x420mm">
    <option value="A4 Photo, 210x297mm">
    <option value="Passport Photo 10x15mm">
    <option value="A1 Poster, 594x841mm">
    <option value="A2 Poster, 420x594mm">
    <option value="A3 Poster, 297x420mm">
    <option value="Poster A0, 841x1189mm">
    <option value="A3 Document, Black and White">
    <option value="A3 Document, Color">
    <option value="A4 Document Black and white">
    <option value="A4 Document Color">
    <option value="Black Magic Cup">
    <option value="White Cup">
    <option value="A4 Document (Scanning)">
    <option value="A0, Frame, Size">
    <option value="A1 frame, 594x841mm">
    <option value="A2 Frame,420x594mm">
    <option value="Frame,297x420mm">
    <option value="Name, Address on Taxi/Combi/Bus both sides, Back and Front">
    <option value="Date Stamp S2660">
    <option value="Stamp Printer C30">
    <option value="Stamp Printer C40">
    <option value="Stamp Printer C50">
    <option value="Stamp Printer C60">
    <option value="Stamp Printer D30">
    <option value="Stamp Printer D40">
    <option value="Stamp Printer D50">
    <option value="Stamp Printer D60">
</datalist>

<script>
    function addItem() {
        const itemsDiv = document.getElementById('items');

        const itemDiv = document.createElement('div');
        itemDiv.className = 'quote-row item-container';

        itemDiv.innerHTML = `
            <input list="descriptions" name="description[]" required>
            <input type="number" name="quantity[]" min="1" required>
            <input type="number" name="unit_price[]" step="0.01" min="0" required>
            <input type="number" name="vat_percent[]" step="0.01" value="14" required>
            <button type="button" class="remove-btn" onclick="removeItem(this)">Remove</button>
        `;

        itemsDiv.appendChild(itemDiv);
    }

    function removeItem(button) {
        const itemDiv = button.parentNode;
        itemDiv.parentNode.removeChild(itemDiv);
    }

    function addItems() {
        const countInput = document.getElementById('itemCount');
        let count = parseInt(countInput.value);
        if (isNaN(count) || count < 1) count = 1;
        if (count > 20) count = 20; // limit max to avoid huge form

        for (let i = 0; i < count; i++) {
            addItem();
        }
    }
</script>

</body>
</html>
