<?php
session_start();
include 'db.php';

// Ensure user is logged in and has a branch
$user_branch = $_SESSION['branch'] ?? null;
if (!$user_branch) {
    die("Access denied: Branch missing.");
}

// Validate POST data
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['job_card_id'], $_POST['stage_name'])) {
    die("Invalid request.");
}

$job_card_id = (int)$_POST['job_card_id'];
$stage_name = trim($_POST['stage_name']);
$remarks = trim($_POST['remarks'] ?? '');

// Validate assigned_to checkboxes
$assigned_ids = [];
if (!empty($_POST['assigned_to']) && is_array($_POST['assigned_to'])) {
    foreach ($_POST['assigned_to'] as $id) {
        $assigned_ids[] = (int)$id;
    }
}

// Convert assigned IDs to comma-separated string
$assigned_to_str = implode(',', $assigned_ids);

// Verify job card belongs to user's branch
$stmt = $conn->prepare("SELECT id FROM job_cards WHERE id = ? AND branch = ?");
$stmt->bind_param("is", $job_card_id, $user_branch);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    $stmt->close();
    die("Job card not found or access denied.");
}
$stmt->close();

// Update assigned_to and remarks for this stage
$upd = $conn->prepare("INSERT INTO job_card_stages (job_card_id, stage_name, assigned_to, remarks)
                       VALUES (?, ?, ?, ?)
                       ON DUPLICATE KEY UPDATE assigned_to = VALUES(assigned_to), remarks = VALUES(remarks)");
$upd->bind_param("isss", $job_card_id, $stage_name, $assigned_to_str, $remarks);
if ($upd->execute()) {
    $_SESSION['message'] = "Stage assignments updated successfully.";
} else {
    $_SESSION['error'] = "Failed to update assignments.";
}
$upd->close();

// Redirect back to job card page
header("Location: view_job.php?id=" . $job_card_id);
exit;
?>
