<?php
// ... (your PHP processing code above)

$branches = ['Jwaneng', 'Letlhakane', 'Other Branch'];
$departments = ['Commercial Branding', 'Signage', 'Bulk Printing', 'Accounts', 'Sales'];
$positions = ['Supervisor', 'Manager', 'Team Lead', 'Staff'];
$statuses = ['Active', 'Inactive', 'On Leave'];

// Preserve submitted values after POST for form repopulation
$post = $_POST ?? [];
?>

<form method="POST">
    <label>Username: <input type="text" name="username" value="<?= htmlspecialchars($post['username'] ?? '') ?>"></label><br>
    <label>Password: <input type="password" name="password"></label><br>

    <label>Branch:
        <select name="branch" required>
            <option value="">-- Select Branch --</option>
            <?php foreach ($branches as $branch): ?>
                <option value="<?= htmlspecialchars($branch) ?>" <?= (isset($post['branch']) && $post['branch'] === $branch) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($branch) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </label><br>

    <label>Department:
        <select name="department" required>
            <option value="">-- Select Department --</option>
            <?php foreach ($departments as $dept): ?>
                <option value="<?= htmlspecialchars($dept) ?>" <?= (isset($post['department']) && $post['department'] === $dept) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($dept) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </label><br>

    <label>Position:
        <select name="position" required>
            <option value="">-- Select Position --</option>
            <?php foreach ($positions as $pos): ?>
                <option value="<?= htmlspecialchars($pos) ?>" <?= (isset($post['position']) && $post['position'] === $pos) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($pos) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </label><br>

    <label>Status:
        <select name="status" required>
            <option value="">-- Select Status --</option>
            <?php foreach ($statuses as $stat): ?>
                <option value="<?= htmlspecialchars($stat) ?>" <?= (isset($post['status']) && $post['status'] === $stat) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($stat) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </label><br>

    <label>Email: <input type="email" name="email" value="<?= htmlspecialchars($post['email'] ?? '') ?>"></label><br>
    <label>Phone: <input type="text" name="phone" value="<?= htmlspecialchars($post['phone'] ?? '') ?>"></label><br>

    <button type="submit">Add Supervisor</button>
</form>

<p><a href="supervisors.php">Back to Supervisors</a></p>
