<?php
session_start();
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) die("Connection failed: " . $mysqli->connect_error);

// Fetch only staff (position = 'Staff') and sort by department then name
$query = "SELECT * FROM employees WHERE position = 'Staff' ORDER BY department ASC, employee_name ASC";
$result = $mysqli->query($query);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Staff Employees</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        h2 {
            margin-bottom: 20px;
        }
        table {
            border-collapse: collapse;
            width: 100%;
            margin-bottom: 30px;
        }
        th, td {
            padding: 8px 12px;
            border: 1px solid #ccc;
        }
        th {
            background-color: #f9f9f9;
        }
        .actions a {
            margin-right: 10px;
            text-decoration: none;
        }
        .actions a:hover {
            text-decoration: underline;
        }
        .links {
            margin-top: 20px;
        }
    </style>
</head>
<body>

<h2>Staff Employees</h2>

<table>
    <thead>
    <tr>
        <th>Name</th>
        <th>Department</th>
        <th>Branch</th>
        <th>Position</th>
        <th>Status</th>
        <th>Email</th>
        <th>Phone</th>
        <th>Actions</th>
    </tr>
    </thead>
    <tbody>
    <?php if ($result && $result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['employee_name']) ?></td>
                <td><?= htmlspecialchars($row['department']) ?></td>
                <td><?= htmlspecialchars($row['branch']) ?></td>
                <td><?= htmlspecialchars($row['position']) ?></td>
                <td><?= htmlspecialchars($row['status']) ?></td>
                <td><?= htmlspecialchars($row['email']) ?></td>
                <td><?= htmlspecialchars($row['phone']) ?></td>
                <td class="actions">
                    <a href="edit_staff.php?id=<?= $row['id'] ?>">Edit</a> |
                    <a href="delete_staff.php?id=<?= $row['id'] ?>" onclick="return confirm('Are you sure you want to delete this staff member?')">Delete</a>
                </td>
            </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr><td colspan="8">No staff employees found.</td></tr>
    <?php endif; ?>
    </tbody>
</table>

<div class="links">
    <a href="add_staff.php">➕ Add New Staff</a> |
    <a href="users.php">View Supervisors</a>
</div>

</body>
</html>
