<?php
session_start();

$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect to MySQL: " . $mysqli->connect_error);
}

$username = $_SESSION['username'] ?? '';
$message = '';
$error = '';

// Fetch employee info
$stmt = $mysqli->prepare("SELECT employee_name, department, position, email, phone, branch FROM employees WHERE employee_name = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$stmt->bind_result($employee_name, $department, $position, $email, $phone, $branch);
$stmt->fetch();
$stmt->close();

// Handle profile update (email, phone, branch)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_profile'])) {
    $new_email = trim($_POST['email']);
    $new_phone = trim($_POST['phone']);
    $new_branch = trim($_POST['branch']);

    if (filter_var($new_email, FILTER_VALIDATE_EMAIL) === false) {
        $error = "Invalid email address.";
    } else {
        $update = $mysqli->prepare("UPDATE employees SET email = ?, phone = ?, branch = ? WHERE employee_name = ?");
        $update->bind_param("ssss", $new_email, $new_phone, $new_branch, $username);
        if ($update->execute()) {
            $message = "Profile updated successfully.";
            $email = $new_email;
            $phone = $new_phone;
            $branch = $new_branch;
        } else {
            $error = "Failed to update profile.";
        }
        $update->close();
    }
}

// Handle password change
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_password'])) {
    $currentPassword = $_POST['current_password'];
    $newPassword = $_POST['new_password'];
    $confirmPassword = $_POST['confirm_password'];

    $stmt = $mysqli->prepare("SELECT password FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->bind_result($hashedPassword);
    $stmt->fetch();
    $stmt->close();

    if (!password_verify($currentPassword, $hashedPassword)) {
        $error = "Current password is incorrect.";
    } elseif ($newPassword !== $confirmPassword) {
        $error = "New passwords do not match.";
    } elseif (strlen($newPassword) < 6) {
        $error = "New password must be at least 6 characters.";
    } else {
        $newHashed = password_hash($newPassword, PASSWORD_DEFAULT);
        $update = $mysqli->prepare("UPDATE users SET password = ? WHERE username = ?");
        $update->bind_param("ss", $newHashed, $username);
        if ($update->execute()) {
            $message = "Password updated successfully.";
        } else {
            $error = "Failed to update password.";
        }
        $update->close();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Department Profile</title>
    <link rel="stylesheet" href="styles.css" />

    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
        }

        nav {
            padding: 10px 20px;
            display: flex;
            justify-content: flex-start;
            gap: 15px;
            width: 100vw;
            box-sizing: border-box;
            border-radius: 0 0 6px 6px;
            background-color: transparent;
            box-shadow: none;
        }

        nav a {
            color: white;
            font-weight: 600;
            text-decoration: none;
            padding: 8px 18px;
            border-radius: 5px;
            background-color: #30307d;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
            transition: background-color 0.3s ease;
        }

        nav a:hover {
            background-color: #4a4aaf;
        }

        .container {
            max-width: 900px;
            margin: 30px auto;
            padding: 0 15px;
        }

        h2 {
            margin-bottom: 15px;
            color: #30307d;
        }

        .forms-container {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
        }

        form {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            flex: 1 1 400px;
            min-width: 280px;
            box-sizing: border-box;
        }

        label {
            display: block;
            margin-top: 12px;
            font-weight: 600;
            color: #333;
        }

        input[type="text"],
        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 8px 10px;
            margin-top: 6px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 14px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }

        input[type="text"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus {
            border-color: #30307d;
            outline: none;
        }

        button {
            margin-top: 20px;
            padding: 10px 18px;
            background-color: #30307d;
            border: none;
            border-radius: 6px;
            color: white;
            font-weight: 600;
            cursor: pointer;
            font-size: 15px;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #4a4aaf;
        }

        .message {
            margin-top: 20px;
            color: green;
            font-weight: 600;
        }

        .error {
            margin-top: 20px;
            color: #c0392b;
            font-weight: 600;
        }

        @media (max-width: 750px) {
            .forms-container {
                flex-direction: column;
            }
            form {
                max-width: 100%;
            }
        }
    </style>
</head>
<body>
<h2> Profile</h2>
<nav>
    <a href="Admins.php">Dashboard</a>
    <a href="Profile.php">My Profile</a>
    <a href="logout.php">Logout</a>
</nav>

<div class="container">

    <div class="forms-container">

        <!-- Profile Update Form -->
        <form method="POST" action="">
            <h3>Edit Contact Info</h3>
            <p><strong>Name:</strong> <?php echo htmlspecialchars($employee_name); ?></p>
            <p><strong>Department:</strong> <?php echo htmlspecialchars($department); ?></p>
            <p><strong>Position:</strong> <?php echo htmlspecialchars($position); ?></p>
            <p><strong>Branch:</strong> <?php echo htmlspecialchars($branch); ?></p>

            <label for="email">Email</label>
            <input type="email" name="email" id="email" required value="<?php echo htmlspecialchars($email); ?>">

            <label for="phone">Phone</label>
            <input type="text" name="phone" id="phone" value="<?php echo htmlspecialchars($phone); ?>">

            <label for="branch">Branch</label>
            <input type="text" name="branch" id="branch" value="<?php echo htmlspecialchars($branch); ?>">

            <button type="submit" name="update_profile">Update Profile</button>
        </form>

        <!-- Password Change Form -->
        <form method="POST" action="">
            <h3>Change Password</h3>

            <label for="current_password">Current Password</label>
            <input type="password" name="current_password" id="current_password" required>

            <label for="new_password">New Password (min 6 characters)</label>
            <input type="password" name="new_password" id="new_password" required minlength="6">

            <label for="confirm_password">Confirm New Password</label>
            <input type="password" name="confirm_password" id="confirm_password" required minlength="6">

            <button type="submit" name="change_password">Change Password</button>
        </form>

    </div>

    <?php if ($message): ?>
        <div class="message"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

</div>

</body>
</html>
