<?php
session_start();

$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect: " . $mysqli->connect_error);
}

// Assuming branch is stored in session on login
$logged_branch = $_SESSION['branch'] ?? '';

$message = "";

$departments = ['Signage', 'Bulk Printing', 'Commercial Branding'];
$commercialProcessTypes = ['Dye Sublimation', 'Embroidery', 'Engraving'];
$branches = ['Jwaneng', 'Letlhakane'];

// Fetch inventory items for the logged branch, grouped by department
$inventory_by_department = [];
$inv_stmt = $mysqli->prepare("SELECT id, name, department, current_stock, unit FROM inventory_items WHERE branch = ?");
$inv_stmt->bind_param("s", $logged_branch);
$inv_stmt->execute();
$inv_res = $inv_stmt->get_result();
while ($inv = $inv_res->fetch_assoc()) {
    $dep = $inv['department'];
    if (!isset($inventory_by_department[$dep])) {
        $inventory_by_department[$dep] = [];
    }
    $inventory_by_department[$dep][] = $inv;
}
$inv_stmt->close();

// === NEW: Prepare flat inventory and threshold for JS low stock toast ===
$lowStockThreshold = 10; // Adjust threshold as needed
$flatInventory = [];
foreach ($inventory_by_department as $dept => $items) {
    foreach ($items as $item) {
        $flatInventory[] = $item;
    }
}
// === END NEW ===

// Handle Add Job Card form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_job_card'])) {
    $status = $_POST['status'] ?? '';
    $due_date = $_POST['due_date'] ?: null;
    $department = $_POST['department'] ?? '';
    $process_type = $_POST['process_type'] ?? null;
    $job_card_number = $_POST['job_card_number'] ?? '';
    $job_order_id = $_POST['job_order_id'] ?? '';
    $customer_name = $_POST['customer_name'] ?? '';
    $contact_person = $_POST['contact_person'] ?? '';
    $telephone = $_POST['telephone'] ?? '';
    $order_description = $_POST['order_description'] ?? '';
    $total_order_quantity = (int)($_POST['total_order_quantity'] ?? 0);
    $delivered_quantity = 0;
    $branch = $logged_branch;
    $completed_date = ($status === 'open') ? null : date('Y-m-d H:i:s');

    $stmt = $mysqli->prepare("INSERT INTO job_cards (job_card_number, department, process_type, status, due_date, completed_date, job_order_id, customer_name, contact_person, telephone, order_description, total_order_quantity, delivered_quantity, branch, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param('sssssssssssiis', $job_card_number, $department, $process_type, $status, $due_date, $completed_date, $job_order_id, $customer_name, $contact_person, $telephone, $order_description, $total_order_quantity, $delivered_quantity, $branch);
    $stmt->execute();

    // Inventory deduction logic starts here
    $job_card_id = $mysqli->insert_id; // get last inserted job card ID

    // Expecting used inventory items from form:
    // Arrays: used_items_ids[], used_items_qty[]
    $used_item_ids = $_POST['used_items_ids'] ?? [];
    $used_item_qtys = $_POST['used_items_qty'] ?? [];

    if (count($used_item_ids) === count($used_item_qtys)) {
        $mysqli->begin_transaction();
        try {
            for ($i = 0; $i < count($used_item_ids); $i++) {
                $item_id = intval($used_item_ids[$i]);
                $qty_used = intval($used_item_qtys[$i]);

                if ($qty_used <= 0) continue; // skip zero or negative

                // Lock row for update
                $check_stock_stmt = $mysqli->prepare("SELECT current_stock FROM inventory_items WHERE id = ? FOR UPDATE");
                $check_stock_stmt->bind_param("i", $item_id);
                $check_stock_stmt->execute();
                $result = $check_stock_stmt->get_result();
                $item = $result->fetch_assoc();
                $check_stock_stmt->close();

                if (!$item) {
                    throw new Exception("Inventory item with ID $item_id not found.");
                }

                if ($item['current_stock'] < $qty_used) {
                    throw new Exception("Insufficient stock for item ID $item_id.");
                }

                // Deduct stock
                $update_stock_stmt = $mysqli->prepare("UPDATE inventory_items SET current_stock = current_stock - ? WHERE id = ?");
                $update_stock_stmt->bind_param("ii", $qty_used, $item_id);
                $update_stock_stmt->execute();
                $update_stock_stmt->close();

                // Insert usage record
                $insert_usage_stmt = $mysqli->prepare("INSERT INTO job_card_inventory (job_card_id, inventory_item_id, quantity_used) VALUES (?, ?, ?)");
                $insert_usage_stmt->bind_param("iii", $job_card_id, $item_id, $qty_used);
                $insert_usage_stmt->execute();
                $insert_usage_stmt->close();
            }

            $mysqli->commit();
            $message = "Job card added for branch " . htmlspecialchars($branch) . ". Process Type: " . htmlspecialchars($process_type) . " and inventory updated.";
        } catch (Exception $e) {
            $mysqli->rollback();
            $message = "Error processing inventory deduction: " . $e->getMessage();
        }
    } else {
        $message = "Inventory items data invalid.";
    }

    $stmt->close();
}

// Handle Return Job Card (Reissue) form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_reissue'])) {
    $original_job_card_number = $_POST['original_job_card_number'] ?? '';
    $return_reason = $_POST['return_reason'] ?? '';
    $department_reissue = $_POST['reissue_department'] ?? '';

    $stmt = $mysqli->prepare("SELECT * FROM job_cards WHERE job_card_number = ? AND branch = ?");
    $stmt->bind_param('ss', $original_job_card_number, $logged_branch);
    $stmt->execute();
    $result = $stmt->get_result();
    $original = $result->fetch_assoc();
    $stmt->close();

    if ($original) {
        $base_number = $original['job_card_number'];
        $stmt = $mysqli->prepare("SELECT job_card_number FROM job_cards WHERE job_card_number LIKE CONCAT(?, '-%') ORDER BY job_card_number DESC LIMIT 1");
        $stmt->bind_param('s', $base_number);
        $stmt->execute();
        $res = $stmt->get_result();
        $last_reissue = $res->fetch_assoc()['job_card_number'] ?? null;
        $stmt->close();

        $suffix = '-1';
        if ($last_reissue) {
            preg_match('/-(\d+)$/', $last_reissue, $matches);
            if (isset($matches[1])) {
                $last_num = intval($matches[1]);
                $suffix = '-' . ($last_num + 1);
            }
        }

        $new_job_card_number = $base_number . $suffix;
        $stmt = $mysqli->prepare("INSERT INTO job_card_reissues (original_job_card_number, new_job_card_number, reason, created_at) VALUES (?, ?, ?, NOW())");
        $stmt->bind_param('sss', $original_job_card_number, $new_job_card_number, $return_reason);
        $stmt->execute();
        $stmt->close();

        $message = "Reissued job card created: $new_job_card_number";
    } else {
        $message = "Original job card not found or does not belong to your branch.";
    }
}

// Generate next job card number
$next_job_card_number = 'JCN-8616';
$stmt = $mysqli->prepare("SELECT job_card_number FROM job_cards WHERE branch = ? ORDER BY CAST(SUBSTRING(job_card_number, 5) AS UNSIGNED) DESC LIMIT 1");
$stmt->bind_param('s', $logged_branch);
$stmt->execute();
$result = $stmt->get_result();
if ($result && $row = $result->fetch_assoc()) {
    preg_match('/(\d+)$/', $row['job_card_number'], $matches);
    if (isset($matches[1])) {
        $next_number = intval($matches[1]) + 1;
        $next_job_card_number = 'JCN-' . $next_number;
    }
}
$stmt->close();

// Fetch completed job cards for reissue dropdown
$stmt = $mysqli->prepare("SELECT job_card_number, department, completed_date FROM job_cards WHERE status = 'closed' AND branch = ? ORDER BY id DESC");
$stmt->bind_param('s', $logged_branch);
$stmt->execute();
$completed_cards = $stmt->get_result();

function renderDepartmentOptions($departments, $selected = '') {
    $options = "";
    foreach ($departments as $d) {
        $sel = ($d === $selected) ? 'selected' : '';
        $options .= "<option value=\"" . htmlspecialchars($d) . "\" $sel>$d</option>";
    }
    return $options;
}

function renderProcessOptions($processes, $selected = '') {
    $options = "";
    foreach ($processes as $p) {
        $sel = ($p === $selected) ? 'selected' : '';
        $options .= "<option value=\"" . htmlspecialchars($p) . "\" $sel>$p</option>";
    }
    return $options;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Masteka Printing Dashboard</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f3f6fc;
            margin: 0;
            padding: 20px;
        }
        h1 {
            color: #30307d;
        }
        h2 {
            color: #1f1f5c;
            border-bottom: 2px solid #30307d;
            padding-bottom: 6px;
            margin-bottom: 15px;
        }
        nav {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            margin-bottom: 30px;
        }
        nav a {
            background-color: #30307d;
            color: white;
            text-decoration: none;
            padding: 10px 16px;
            border-radius: 8px;
            font-weight: bold;
            transition: 0.3s ease;
        }
        nav a:hover {
            background-color: #1f1f5c;
            transform: translateY(-2px);
        }
        .message {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            padding: 12px 18px;
            color: #155724;
            border-radius: 6px;
            margin-bottom: 25px;
            max-width: 600px;
        }
        .branch-info {
            margin-bottom: 25px;
            font-weight: bold;
            color: #30307d;
            font-size: 18px;
        }
        .form-container {
            display: flex;
            flex-wrap: wrap;
            gap: 40px;
        }
        form {
            background-color: white;
            padding: 25px 30px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            flex: 1 1 420px;
            max-width: 600px;
        }
        label {
            display: block;
            font-weight: bold;
            margin-top: 15px;
            margin-bottom: 5px;
            color: #333;
        }
        input[type="text"],
        input[type="number"],
        input[type="date"],
        select,
        textarea {
            width: 100%;
            padding: 10px;
            margin-top: 2px;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 15px;
            background-color: #f9f9f9;
        }
        textarea {
            resize: vertical;
        }
        button {
            margin-top: 20px;
            background: #30307d;
            color: white;
            border: none;
            padding: 12px 20px;
            font-size: 16px;
            border-radius: 8px;
            cursor: pointer;
            transition: 0.3s ease;
        }
        button:hover {
            background: #1f1f5c;
        }
        #inventory-usage-section {
            margin-top: 20px;
            background: #e9ecef;
            padding: 15px;
            border-radius: 8px;
        }
        #inventory-items-container > div {
            margin-bottom: 10px;
        }

        /* === NEW: Toast Styles === */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
        }
        .toast {
            background-color: #ff4d4d;
            color: white;
            padding: 12px 18px;
            margin-top: 10px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.2);
            animation: slideIn 0.4s ease, fadeOut 0.5s ease 4.5s forwards;
            font-weight: bold;
        }
        @keyframes slideIn {
            from { opacity: 0; transform: translateX(100%); }
            to { opacity: 1; transform: translateX(0); }
        }
        @keyframes fadeOut {
            to { opacity: 0; }
        }
        /* === END NEW === */
    </style>
</head>
<body>

<!-- === NEW: Toast Container === -->
<div id="toast-container" class="toast-container"></div>
<!-- === END NEW === -->

<div class="branch-info">
    <h2>Branch: <?= htmlspecialchars(ucfirst(strtolower($logged_branch ?: 'Not Set'))) ?></h2>
</div>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="inventory_list.php">Inventory </a>
    <a href="insert.php">Add Job Card</a>
    <a href="sales_jobs.php">Invoices</a>

</nav>

<?php if ($message): ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<div class="form-container">

    <!-- Add Job Card Form -->
    <form method="POST">
        <h2>Add Job Card</h2>

        <label>Job Card Number
            <input type="text" id="job_card_number" name="job_card_number" value="<?= htmlspecialchars($next_job_card_number) ?>" required />
        </label>

        <label>Branch
            <input type="text" value="<?= htmlspecialchars(ucfirst(strtolower($logged_branch ?: 'Not Set'))) ?>" readonly />
        </label>

        <label>Order NO:
            <input type="text" id="job_order_id" name="job_order_id" required readonly />
        </label>

        <label>Customer/Company Name
            <input type="text" name="customer_name" required />
        </label>

        <label>Contact Person
            <input type="text" name="contact_person" required />
        </label>

        <label>Telephone
            <input type="text" name="telephone" required />
        </label>

        <label>Order Description
            <textarea name="order_description" rows="3" required></textarea>
        </label>

        <label>Department
            <select name="department" required id="departmentSelect">
                <?= renderDepartmentOptions($departments) ?>
            </select>
        </label>

        <label id="processTypeLabel" style="display:none;">
            Process Type
            <select name="process_type" id="processTypeSelect">
                <option value="">-- Select Process Type --</option>
                <?= renderProcessOptions($commercialProcessTypes) ?>
            </select>
        </label>

        <!-- Inventory usage inputs -->
        <div id="inventory-usage-section" style="display:none;">
            <h3>Inventory Items Used</h3>
            <button type="button" id="add-inventory-item-btn">+ Add Inventory Item</button>
            <div id="inventory-items-container"></div>
        </div>

        <label>Status
            <select name="status" required>
                <option value="open">Open</option>
                <option value="closed">Closed</option>
            </select>
        </label>

        <label>Due Date
            <input type="date" name="due_date" />
        </label>

        <label>Total Order Quantity
            <input type="number" name="total_order_quantity" min="0" required />
        </label>

        <input type="hidden" name="delivered_quantity" value="0" />
        <button type="submit" name="add_job_card">Add Job Card</button>
    </form>

    <!-- Return Job Card (Reissue) Form -->
    <form method="POST">
        <h2>Return Job Card</h2>

        <label>Job Card Number
            <select id="original_job_card_number" name="original_job_card_number" required>
                <option value="">-- Select --</option>
                <?php
                $jobCardsJsData = [];
                while ($c = $completed_cards->fetch_assoc()):
                    $jc = htmlspecialchars($c['job_card_number']);
                    $dept = htmlspecialchars($c['department']);
                    $comp_date = htmlspecialchars($c['completed_date']);
                    $jobCardsJsData[$jc] = $dept;
                    ?>
                    <option value="<?= $jc ?>">
                        <?= $jc ?> (<?= $dept ?> | Completed: <?= $comp_date ?>)
                    </option>
                <?php endwhile; ?>
            </select>
        </label>

        <label>Department
            <select id="reissue_department" name="reissue_department" required>
                <option value="">-- Select Department --</option>
                <?= renderDepartmentOptions($departments) ?>
            </select>
        </label>

        <label>Reason for Return
            <textarea name="return_reason" required rows="3"></textarea>
        </label>

        <button type="submit" name="create_reissue">Create Reissue</button>
    </form>

</div>

<script>
    // Preloaded job card department data for reissue form
    const jobCardsDept = <?= json_encode($jobCardsJsData ?? []) ?>;

    const originalJobCardSelect = document.getElementById('original_job_card_number');
    const reissueDepartmentSelect = document.getElementById('reissue_department');

    originalJobCardSelect.addEventListener('change', () => {
        const selectedJobCard = originalJobCardSelect.value;
        if (jobCardsDept[selectedJobCard]) {
            reissueDepartmentSelect.value = jobCardsDept[selectedJobCard];
        } else {
            reissueDepartmentSelect.value = '';
        }
    });

    // Department and Process Type dynamic display in Add Job Card form
    const departmentSelect = document.getElementById('departmentSelect');
    const processTypeLabel = document.getElementById('processTypeLabel');
    const processTypeSelect = document.getElementById('processTypeSelect');
    const inventoryUsageSection = document.getElementById('inventory-usage-section');
    const inventoryItemsContainer = document.getElementById('inventory-items-container');
    const addInventoryBtn = document.getElementById('add-inventory-item-btn');

    // Inventory items data grouped by department from PHP for dynamic dropdowns
    const inventoryByDepartment = <?= json_encode($inventory_by_department) ?>;

    // Show/hide process type and inventory usage based on department
    function updateFormSections() {
        const dep = departmentSelect.value;

        if (dep === 'Commercial Branding') {
            processTypeLabel.style.display = 'block';
        } else {
            processTypeLabel.style.display = 'none';
            processTypeSelect.value = '';
        }

        // Show inventory usage section if department has inventory
        if (inventoryByDepartment[dep] && inventoryByDepartment[dep].length > 0) {
            inventoryUsageSection.style.display = 'block';
            // Clear existing items container
            inventoryItemsContainer.innerHTML = '';
        } else {
            inventoryUsageSection.style.display = 'none';
            inventoryItemsContainer.innerHTML = '';
        }
    }

    departmentSelect.addEventListener('change', updateFormSections);
    updateFormSections();

    // Add new inventory item input group dynamically
    addInventoryBtn.addEventListener('click', () => {
        const dep = departmentSelect.value;
        if (!dep || !inventoryByDepartment[dep]) {
            alert('Please select a department with inventory items first.');
            return;
        }

        const div = document.createElement('div');
        div.style.marginBottom = '10px';

        const select = document.createElement('select');
        select.name = 'used_items_ids[]';
        select.required = true;

        const defaultOption = document.createElement('option');
        defaultOption.value = '';
        defaultOption.textContent = '-- Select Inventory Item --';
        select.appendChild(defaultOption);

        inventoryByDepartment[dep].forEach(item => {
            const option = document.createElement('option');
            option.value = item.id;
            option.textContent = item.name + ` (Stock: ${item.current_stock} ${item.unit})`;
            select.appendChild(option);
        });

        const qtyInput = document.createElement('input');
        qtyInput.type = 'number';
        qtyInput.name = 'used_items_qty[]';
        qtyInput.min = '1';
        qtyInput.placeholder = 'Quantity Used';
        qtyInput.required = true;
        qtyInput.style.marginLeft = '10px';
        qtyInput.style.width = '120px';

        const removeBtn = document.createElement('button');
        removeBtn.type = 'button';
        removeBtn.textContent = 'Remove';
        removeBtn.style.marginLeft = '10px';
        removeBtn.onclick = () => div.remove();

        div.appendChild(select);
        div.appendChild(qtyInput);
        div.appendChild(removeBtn);

        inventoryItemsContainer.appendChild(div);
    });

    function showToast(message) {
        const toastContainer = document.getElementById('toast-container');
        const toast = document.createElement('div');
        toast.className = 'toast';
        toast.textContent = message;
        toastContainer.appendChild(toast);
        setTimeout(() => {
            toast.style.opacity = '0';
            setTimeout(() => toast.remove(), 500);
        }, 5000);
    }

    const lowStockThreshold = <?= json_encode($lowStockThreshold) ?>;
    const flatInventory = <?= json_encode($flatInventory) ?>;

    function showLowStockToasts() {
        const toastContainer = document.getElementById('toast-container');
        toastContainer.innerHTML = ''; // clear previous toasts

        flatInventory.forEach(item => {
            if (item.current_stock <= lowStockThreshold) {
                showToast(`Low stock: ${item.name} (${item.current_stock} ${item.unit} left)`);
            }
        });
    }

    document.addEventListener('DOMContentLoaded', () => {
        showLowStockToasts();
        setInterval(showLowStockToasts, 10000);
    });

</script>

</body>
</html>
