<?php
use fpdf\fpdf\FPDF;
require('fpdf/fpdf.php');




class ProposalPDF extends FPDF

{

    function Header()

    {

        $this->SetFont('Arial', 'B', 14);

        $this->Cell(0, 10, 'Nail Tech Booking App - Project Proposal', 0, 1, 'C');

        $this->Ln(5);

    }



    function chapterTitle($title)

    {

        $this->SetFont('Arial', 'B', 12);

        $this->Cell(0, 10, $title, 0, 1);

        $this->Ln(2);

    }



    function chapterBody($body)

    {

        $this->SetFont('Arial', '', 11);

        $this->Multicell(0, 8, $body);

        $this->Ln();

    }

}



$pdf = new ProposalPDF();

$pdf->AddPage();



$pdf->chapterTitle("Project Name (Working Title):");

$pdf->chapterBody("GlamBook – Simplified Bookings for Nail & Hair Artists");



$pdf->chapterTitle("Problem Statement");

$pdf->chapterBody(

    "Nail technicians and hairstylists often rely on:\n"

    ."- Instagram DMs\n- WhatsApp back-and-forth\n- Paper diaries\n"

    ."to manage bookings. This results in:\n"

    ."- Missed appointments\n- Double bookings\n- Limited client reach\n- No booking analytics"

);



$pdf->chapterTitle("Proposed Solution");

$pdf->chapterBody(

    "A mobile-friendly web booking app that allows independent beauty professionals to:\n"

    ."- Set up a booking page in minutes\n"

    ."- Share a custom link with clients\n"

    ."- Let clients book services, select times, and get WhatsApp confirmations\n"

    ."- Track appointments from a dashboard"

);



$pdf->chapterTitle("Core Features (MVP)");

$pdf->chapterBody(

    "• Booking Page: Each tech gets a branded page (/nailsbyfaith)\n"

    ."• Service Listings: Add services, durations, prices\n"

    ."• Time Slots: Set availability (days/times)\n"

    ."• Booking System: Clients choose service, date, time\n"

    ."• WhatsApp Notifications: Confirmation sent to the tech\n"

    ."• Booking Management: Dashboard to view upcoming appointments\n"

    ."• Booking Limits: Block off already booked times"

);



$pdf->chapterTitle("Extended Features (Future)");

$pdf->chapterBody(

    "• Calendar integration (Google/Outlook)\n"

    ."• Client management (names, history)\n"

    ."• Deposits or payments (via Stripe/Flutterwave)\n"

    ."• Email/SMS reminders\n"

    ."• Review system"

);



$pdf->chapterTitle("Tech Stack");

$pdf->chapterBody(

    "Frontend: React + React Router DOM\n"

    ."Styling: CSS or Tailwind CSS\n"

    ."Hosting: Vercel\n"

    ."Database: Firebase / Supabase (for bookings + auth)\n"

    ."Notifications: WhatsApp API (direct or Twilio)\n"

    ."Payments: Stripe or Flutterwave (subscriptions & deposits)"

);



$pdf->chapterTitle("Monetization Model");

$pdf->chapterBody(

    "Free Trial: 7 or 14 days\n"

    ."Subscription:\n"

    ."- BWP 100/month Basic: Bookings + WhatsApp + Dashboard\n"

    ."- BWP 150/month Pro: Branding + Booking Analytics\n"

    ."Paid via card or mobile money"

);



$pdf->chapterTitle("Development Timeline");

$pdf->chapterBody(

    "Phase 1: MVP (2–3 weeks) - Booking page, time slots, dashboard\n"

    ."Phase 2: Multi-user (1 week) - Authentication, user-based routing\n"

    ."Phase 3: WhatsApp (2–3 days) - Send booking confirmation messages\n"

    ."Phase 4: Payments (1 week) - Stripe/FW integration\n"

    ."Phase 5: Feedback (Ongoing) - Work with beta users to refine"

);



$pdf->chapterTitle("Why This Works");

$pdf->chapterBody(

    "• Nail techs don’t need full websites — just a smart, client-facing booking tool\n"

    ."• They want simplicity: “pick a service → pick time → done”\n"

    ."• Saves time, improves professionalism, increases repeat bookings"

);



$pdf->chapterTitle("Next Steps");

$pdf->chapterBody(

    "1. Finalize MVP (React + Firebase)\n"

    ."2. Launch demo for 1–3 nail techs (early testers)\n"

    ."3. Collect feedback and iterate\n"

    ."4. Add subscription/payments\n"

    ."5. Launch 🚀"

);



// Stream PDF to browser for immediate view/download

$pdf->Output('I', 'Nail_Tech_Booking_App_Proposal.pdf');

exit;

?>