<?php
session_start();

// Check if user is logged in and has department and branch info
if (!isset($_SESSION['username'], $_SESSION['department'], $_SESSION['branch'])) {
    header("Location: login.php");
    exit;
}

// Database connection
$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect to MySQL: " . $mysqli->connect_error);
}

$department = $_SESSION['department'];
$branch = $_SESSION['branch'];

// Get job cards for this department and branch
$sql = "SELECT * FROM job_cards WHERE department = ? AND branch = ? ORDER BY due_date ASC";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("ss", $department, $branch);
$stmt->execute();
$jobs = $stmt->get_result();

// Group jobs by month
$jobsByMonth = [];
while ($job = $jobs->fetch_assoc()) {
    $monthKey = date("F Y", strtotime($job['due_date'])); // e.g. "August 2025"
    $jobsByMonth[$monthKey][] = $job;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title><?= htmlspecialchars($department . " - " . $branch); ?> Dashboard</title>
    <link rel="stylesheet" href="styles.css" />
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        header { margin-bottom: 30px; }
        table { border-collapse: collapse; width: 100%; margin-top: 15px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
        th { background-color: #eee; }

        /* Tabs */
        .tabs { display: flex; gap: 10px; margin-bottom: 20px; flex-wrap: wrap; }
        .tab-btn {
            padding: 8px 15px;
            border: none;
            cursor: pointer;
            background: #ccc;
            border-radius: 5px;
            font-weight: bold;
        }
        .tab-btn.active { background: #333; color: white; }
        .tab-content { display: none; }
        .tab-content.active { display: block; }

        /* Status highlights */
        .status-open { background-color:  #f8d7da; }
    </style>
    <script>
        function showTab(month) {
            document.querySelectorAll(".tab-content").forEach(el => el.classList.remove("active"));
            document.querySelectorAll(".tab-btn").forEach(el => el.classList.remove("active"));
            document.getElementById("tab-" + month).classList.add("active");
            document.getElementById("btn-" + month).classList.add("active");
        }
    </script>
</head>
<body>
<header>
    <h2>
        <?= htmlspecialchars(ucwords($department) . " Department - " . ucwords($branch) . " Branch") ?>
    </h2>
    <nav style="padding: 10px 20px; border-radius: 6px; margin-top: 10px;">
        <a href="index.php" style="color: white; text-decoration: none; margin-right: 15px; font-weight: bold;">Dashboard</a>
        <a href="profile.php" style="color: white; text-decoration: none; margin-right: 15px; font-weight: bold;">My Profile</a>
        <a href="logout.php" style="color: white; text-decoration: none; font-weight: bold;">Logout</a>
    </nav>
    <p>Welcome, <?= htmlspecialchars($_SESSION['username']); ?></p>
</header>

<main>
    <h3>Active Job Cards</h3>

    <?php if (empty($jobsByMonth)): ?>
        <p>No job cards found for <?= htmlspecialchars($department . " - " . $branch); ?>.</p>
    <?php else: ?>
        <!-- Tab buttons -->
        <div class="tabs">
            <?php $first = true; foreach ($jobsByMonth as $month => $monthJobs): ?>
                <button id="btn-<?= md5($month) ?>" class="tab-btn <?= $first ? 'active' : '' ?>"
                        onclick="showTab('<?= md5($month) ?>')">
                    <?= htmlspecialchars($month) ?>
                </button>
                <?php $first = false; endforeach; ?>
        </div>

        <!-- Tab contents -->
        <?php $first = true; foreach ($jobsByMonth as $month => $monthJobs):
            // Count open/closed
            $openCount = 0;
            $closedCount = 0;
            foreach ($monthJobs as $jobStatusCheck) {
                if (strtolower($jobStatusCheck['status']) === 'open') {
                    $openCount++;
                } else {
                    $closedCount++;
                }
            }
            ?>
            <div id="tab-<?= md5($month) ?>" class="tab-content <?= $first ? 'active' : '' ?>">
                <h4>
                    <?= htmlspecialchars($month) ?>
                    (Open: <?= $openCount ?>, Closed: <?= $closedCount ?>)
                </h4>
                <table>
                    <thead>
                    <tr>
                        <th>Job Card</th>
                        <th>Customer</th>
                        <th>Contact Person</th>
                        <th>Due Date</th>
                        <th>Status</th>
                        <th>Current Stage</th>
                        <th>Delivered By</th>
                        <th>Delivery Note</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($monthJobs as $job):
                        // Delivery note
                        $deliverySql = "SELECT uploaded_by, note_file FROM delivery_notes WHERE job_card_id = ? ORDER BY id DESC LIMIT 1";
                        $del_stmt = $mysqli->prepare($deliverySql);
                        $delivery = null;
                        if ($del_stmt) {
                            $del_stmt->bind_param('i', $job['id']);
                            $del_stmt->execute();
                            $delivery = $del_stmt->get_result()->fetch_assoc();
                            $del_stmt->close();
                        }

                        // Stage
                        $stageSql = "SELECT stage_name FROM job_card_stages WHERE job_card_id = ? ORDER BY id DESC LIMIT 1";
                        $stage_stmt = $mysqli->prepare($stageSql);
                        $stageResult = null;
                        if ($stage_stmt) {
                            $stage_stmt->bind_param('i', $job['id']);
                            $stage_stmt->execute();
                            $stageResult = $stage_stmt->get_result()->fetch_assoc();
                            $stage_stmt->close();
                        }

                        // Row color based on status
                        $rowClass = strtolower($job['status']) === 'open' ? 'status-open' : 'status-closed';
                        ?>
                        <tr class="<?= $rowClass ?>">
                            <td><?= htmlspecialchars($job['job_card_number']); ?></td>
                            <td><?= htmlspecialchars($job['customer_name']); ?></td>
                            <td><?= htmlspecialchars($job['contact_person']); ?></td>
                            <td><?= htmlspecialchars($job['due_date']); ?></td>
                            <td><?= htmlspecialchars($job['status']); ?></td>
                            <td><?= $stageResult ? htmlspecialchars($stageResult['stage_name']) : 'Not Started'; ?></td>
                            <td><?= $delivery ? htmlspecialchars($delivery['uploaded_by']) : 'N/A'; ?></td>
                            <td>
                                <?php if ($delivery && !empty($delivery['note_file'])): ?>
                                    <a href="<?= htmlspecialchars($delivery['note_file']); ?>" target="_blank">View Note</a>
                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td><a href="view_job.php?id=<?= urlencode($job['id']); ?>">View</a></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php $first = false; endforeach; ?>
    <?php endif; ?>
</main>
</body>
</html>
