<?php
session_start();

// Make sure branch info is set in session
$branch = $_SESSION['branch'] ?? null;
if (!$branch) {
    die("User branch not defined.");
}

$mysqli = new mysqli("localhost", "root", "", "mas_dashboard");
if ($mysqli->connect_errno) {
    die("Failed to connect to MySQL: " . $mysqli->connect_error);
}

$message = '';

// Fetch all distinct departments for filter dropdown limited to user's branch
$res = $mysqli->prepare("SELECT DISTINCT department FROM job_cards WHERE department IS NOT NULL AND branch = ? ORDER BY department ASC");
$res->bind_param('s', $branch);
$res->execute();
$departments_result = $res->get_result();

$departments = [];
while ($d = $departments_result->fetch_assoc()) {
    $departments[] = $d['department'];
}

// Get selected department from GET param (or show all)
$selected_department = $_GET['department'] ?? 'all';

// Handle form submission to add invoice number and mark invoiced
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)($_POST['job_card_id'] ?? 0);
    $invoice_number = trim($_POST['invoice_number'] ?? '');

    if ($id && $invoice_number !== '') {
        // Only update if job is dispatched and not yet invoiced and belongs to user's branch
        $stmt = $mysqli->prepare("UPDATE job_cards SET invoice_number = ?, invoiced = 1, status = 'dispatched' WHERE id = ? AND dispatched = 1 AND invoiced = 0 AND branch = ?");
        $stmt->bind_param('sis', $invoice_number, $id, $branch);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            // Fetch job card number for success message
            $stmt2 = $mysqli->prepare("SELECT job_card_number FROM job_cards WHERE id = ? AND branch = ?");
            $stmt2->bind_param('is', $id, $branch);
            $stmt2->execute();
            $stmt2->bind_result($job_card_number);
            $stmt2->fetch();
            $stmt2->close();

            $message = "Job Card #$job_card_number invoiced successfully.";
        } else {
            $message = "Failed to invoice. Ensure the job is dispatched, not already invoiced, and belongs to your branch.";
        }
        $stmt->close();
    } else {
        $message = "Invoice number is required.";
    }
}

// Prepare query to fetch job cards filtered by department and branch
if ($selected_department === 'all') {
    $query = "SELECT id, job_card_number, customer_name, order_description, status, invoice_number, dispatched, invoiced, department FROM job_cards WHERE branch = ? ORDER BY due_date DESC";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('s', $branch);
} else {
    $query = "SELECT id, job_card_number, customer_name, order_description, status, invoice_number, dispatched, invoiced, department FROM job_cards WHERE department = ? AND branch = ? ORDER BY due_date DESC";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ss', $selected_department, $branch);
}
$stmt->execute();
$result = $stmt->get_result();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Accounts </title>
    <link rel="stylesheet" href="style.css" />

    <style>
        body {
            font-family: Arial, sans-serif;
            background: #eef6fc;
            color: #30307d;
            padding: 20px;
        }
        h2 {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: left;
        }
        th {
            background-color: #30307d;
            color: white;
        }
        input[type="text"] {
            padding: 6px;
            width: 140px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        button {
            background: #30307d;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background: #1f1f5c;
        }
        .message {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            padding: 10px;
            margin-bottom: 20px;
            color: #155724;
            border-radius: 5px;
            max-width: 600px;
        }
        .status-dispatched {
            color: green;
            font-weight: bold;
        }
        .status-open {
            color: #f36e25;
            font-weight: bold;
        }
        .filter-form {
            margin-bottom: 20px;
        }
        select {
            padding: 6px;
            font-size: 1em;
        }
    </style>
</head>
<body>

<h2>Accounts - Branch: <?= htmlspecialchars(ucwords($branch)) ?></h2>
<nav style="
        padding: 10px 20px;
        border-radius: 6px;
        font-family: Arial, sans-serif;
        margin-top: 10px;
    ">
    <a href="index.php" style="color: white; text-decoration: none; margin-right: 15px; font-weight: bold;">Dashboard</a>
    <a href="profile.php" style="color: white; text-decoration: none; margin-right: 15px; font-weight: bold;">My Profile</a>
    <a href="logout.php" style="color: white; text-decoration: none; font-weight: bold;">Logout</a>
</nav>

<form method="get" class="filter-form">
    <label for="department">Filter by Department:</label>
    <select name="department" id="department" onchange="this.form.submit()">
        <option value="all" <?= $selected_department === 'all' ? 'selected' : '' ?>>All Departments</option>
        <?php foreach ($departments as $dept): ?>
            <option value="<?= htmlspecialchars($dept) ?>" <?= $selected_department === $dept ? 'selected' : '' ?>><?= htmlspecialchars($dept) ?></option>
        <?php endforeach; ?>
    </select>
</form>

<?php if ($message): ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<?php if ($result->num_rows === 0): ?>
    <p>No job cards found for this department and branch.</p>
<?php else: ?>
    <table>
        <thead>
        <tr>
            <th>Job Card Number</th>
            <th>Customer</th>
            <th>Description</th>
            <th>Department</th>
            <th>Status</th>
            <th>Invoice Number</th>
            <th>Invoice</th>
        </tr>
        </thead>
        <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
            <?php
            // Determine display status
            $display_status = $row['dispatched'] ? 'dispatched' : 'open';
            $status_class = $row['dispatched'] ? 'status-dispatched' : 'status-open';

            // Show invoice input only if dispatched and not invoiced
            $can_invoice = $row['dispatched'] && !$row['invoiced'];
            ?>
            <tr>
                <td><?= htmlspecialchars($row['job_card_number']) ?></td>
                <td><?= htmlspecialchars($row['customer_name']) ?></td>
                <td><?= htmlspecialchars($row['order_description']) ?></td>
                <td><?= htmlspecialchars($row['department']) ?></td>
                <td class="<?= $status_class ?>"><?= $display_status ?></td>
                <td>
                    <form method="post" style="margin:0;">
                        <input type="hidden" name="job_card_id" value="<?= (int)$row['id'] ?>">
                        <?php if ($can_invoice): ?>
                            <input type="text" name="invoice_number" value="<?= htmlspecialchars($row['invoice_number'] ?? '') ?>" placeholder="Invoice #" required />
                        <?php else: ?>
                            <input type="text" value="<?= htmlspecialchars($row['invoice_number'] ?? '') ?>" readonly />
                        <?php endif; ?>
                </td>
                <td>
                    <?php if ($can_invoice): ?>
                        <button type="submit">Invoice</button>
                    <?php elseif ($row['invoiced']): ?>
                        Invoiced
                    <?php else: ?>
                        -
                    <?php endif; ?>
                    </form>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
<?php endif; ?>

</body>
</html>
